/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Policy;
import org.junit.Assert;
import org.junit.Test;

public class PolicyStoreTest {
    @Test
    public void testPriorityOrder() {
        PolicyStore store = PolicyStore.getInstance();
        store.clear();
        store.add((Policy)new DynamicPolicy("lowest", 0L));
        Assert.assertEquals((long)0L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("lower", 1L));
        Assert.assertEquals((long)1L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("more important", 4L));
        Assert.assertEquals((long)4L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("imporant", 3L));
        Assert.assertEquals((long)4L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("normal", 2L));
        Assert.assertEquals((long)4L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("most imporant", 5L));
        Assert.assertEquals((long)5L, (long)((Policy)store.getList().get(0)).getPriority());
        store.clear();
    }

    @Test
    public void testPriorityDuplicates() {
        PolicyStore store = PolicyStore.getInstance();
        store.clear();
        store.add((Policy)new DynamicPolicy("not important", 0L));
        Assert.assertEquals((long)0L, (long)((Policy)store.getList().get(0)).getPriority());
        Assert.assertEquals((long)1L, (long)store.size());
        store.add((Policy)new DynamicPolicy("important", 1L));
        Assert.assertEquals((long)2L, (long)store.size());
        Assert.assertEquals((long)1L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("not imporant too", 0L));
        Assert.assertEquals((long)3L, (long)store.size());
        Assert.assertEquals((long)1L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("equally imporant", 1L));
        Assert.assertEquals((long)4L, (long)store.size());
        store.clear();
    }

    @Test
    public void testUriDuplicates() {
        PolicyStore store = PolicyStore.getInstance();
        store.clear();
        store.add((Policy)new DynamicPolicy("unique", 0L));
        Assert.assertEquals((long)1L, (long)store.size());
        store.add((Policy)new DynamicPolicy("not unique", 0L));
        Assert.assertEquals((long)2L, (long)store.size());
        store.add((Policy)new DynamicPolicy("not unique", 0L));
        Assert.assertEquals((long)2L, (long)store.size());
        Assert.assertEquals((long)0L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("not unique", 1L));
        Assert.assertEquals((long)2L, (long)store.size());
        Assert.assertEquals((long)1L, (long)((Policy)store.getList().get(0)).getPriority());
        store.add((Policy)new DynamicPolicy("unique too", 0L));
        Assert.assertEquals((long)3L, (long)store.size());
        store.clear();
    }
}

