/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSetRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class PolicyTest {
    public static final String USER_ACCOUNTS_HOME_FIRSTTIME = "../home/src/main/resources/rdf/accessControl/firsttime/";
    public static final String ADMIN = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN";
    public static final String EDITOR = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR";
    public static final String SELF_EDITOR = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR";
    public static final String CURATOR = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR";
    public static final String PUBLIC = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC";
    protected static final String CUSTOM = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM";
    public static final String ONTOLOGY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/ontology.n3";
    public static final String OPERATIONS_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/operations.n3";
    public static final String SUBJECT_TYPES = "../home/src/main/resources/rdf/accessControl/firsttime/subject_types.n3";
    public static final String OBJECT_TYPES = "../home/src/main/resources/rdf/accessControl/firsttime/object_types.n3";
    public static final String ATTRIBUTES_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/attributes.n3";
    public static final String OPERATORS_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/operators.n3";
    public static final String NAMED_KEY_COMPONENTS_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/named_key_components.n3";
    public static final String PROFILE_PROXIMITY_QUERY = "../home/src/main/resources/rdf/accessControl/firsttime/profile_proximity_query.n3";
    public static final String TEST_DECISIONS = "../home/src/main/resources/rdf/accessControl/firsttime/decisions.n3";
    public static final String ROLES = "../home/src/main/resources/rdf/accessControl/firsttime/roles.n3";
    protected static final String RESOURCES_PREFIX = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/";
    protected static final String RESOURCES_RULES_PREFIX = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/";
    public static final String VALID_POLICY = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_valid.n3";
    public static final String VALID_POLICY_TEMPLATE = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_valid_set.n3";
    public static final String BROKEN_POLICY_TEMPLATE = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/test_policy_broken_set.n3";
    public static final String TEMPLATE_CLASS_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_class.n3";
    public static final String TEMPLATE_PROPERTIES_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_property.n3";
    public static final String TEMPLATE_RELATED_PROPERTIES_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_access_related_allowed_property.n3";
    public static final String TEMPLATE_RELATED_UPDATE_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_update_related_allowed_property.n3";
    protected static final List<String> ROLE_LIST = Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
    public static final String PREFIX = "https://vivoweb.org/ontology/vitro-application/auth/individual/";
    public static final String DATASET = "_dataset";
    public static final String EXT = ".n3";
    private static final Log log = LogFactory.getLog(PolicyTest.class);
    protected static final List<String> entityPolicies = Arrays.asList("../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_class.n3", "../home/src/main/resources/rdf/accessControl/firsttime/template_access_allowed_property.n3", "../home/src/main/resources/rdf/accessControl/firsttime/template_access_related_allowed_property.n3", "../home/src/main/resources/rdf/accessControl/firsttime/template_update_related_allowed_property.n3");
    protected Model accessControlModel;
    protected PolicyLoader loader;
    protected Dataset configurationDataSet;

    @Before
    public void init() {
        this.accessControlModel = ModelFactory.createDefaultModel();
        this.configurationDataSet = DatasetFactory.createTxnMem();
        this.configurationDataSet.addNamedModel("http://vitro.mannlib.cornell.edu/default/access-control", this.accessControlModel);
        this.load(OPERATIONS_PATH);
        this.load(ROLES);
        this.load(SUBJECT_TYPES);
        this.load(OBJECT_TYPES);
        this.load(ATTRIBUTES_PATH);
        this.load(OPERATORS_PATH);
        this.load(PROFILE_PROXIMITY_QUERY);
        this.load(TEST_DECISIONS);
        this.load(NAMED_KEY_COMPONENTS_PATH);
        RDFServiceModel rdfService = new RDFServiceModel(this.configurationDataSet);
        AttributeValueSetRegistry.getInstance().clear();
        PolicyLoader.initialize((RDFService)rdfService);
        this.loader = PolicyLoader.getInstance();
        Logger logger = LogManager.getLogger(PolicyLoader.class);
        logger.setLevel(Level.ERROR);
    }

    @After
    public void finish() {
        AttributeValueSetRegistry.getInstance().clear();
    }

    protected void countRulesAndAttributes(DynamicPolicy policy, int ruleCount, Set<Integer> checksCount) {
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Set rules = policy.getRules();
        Map<String, AccessRule> ruleMap = rules.stream().collect(Collectors.toMap(r -> r.getRuleUri(), r -> r));
        if (ruleCount != ruleMap.size()) {
            log.error((Object)String.format("Rules count %s doesn't match for policy %s", ruleMap.size(), policy.getUri()));
            for (AccessRule ar : ruleMap.values()) {
                log.error((Object)String.format("Rule uri %s", ar.getRuleUri()));
            }
        }
        Assert.assertEquals((long)ruleCount, (long)ruleMap.size());
        for (AccessRule ar : ruleMap.values()) {
            if (!checksCount.contains(ar.getChecks().size())) {
                log.error((Object)String.format("Checks count %s doesn't match for policy %s", ar.getChecks().size(), policy.getUri()));
                for (String checkUri : ar.getCheckUris()) {
                    log.error((Object)String.format("Checks uri %s", checkUri));
                }
            }
            Assert.assertTrue((boolean)checksCount.contains(ar.getChecks().size()));
            for (Check att : ar.getChecks()) {
                Assert.assertTrue((!att.getValues().isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    protected void loadAllEntityPolicies() {
        for (String policyPath : entityPolicies) {
            this.load(policyPath);
        }
    }

    protected void load(String filePath) {
        try {
            this.accessControlModel.enterCriticalSection(false);
            this.accessControlModel.read(filePath);
        }
        finally {
            this.accessControlModel.leaveCriticalSection();
        }
        this.configurationDataSet.replaceNamedModel("http://vitro.mannlib.cornell.edu/default/access-control", this.accessControlModel);
    }

    protected void load(Model m, String filePath) {
        try {
            m.enterCriticalSection(false);
            m.read(filePath);
        }
        finally {
            m.leaveCriticalSection();
        }
    }
}

