/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class ProximityTest
extends PolicyTest {
    private static final String PROXIMITY_POLICY_PATH = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/proximity_test_policy.n3";
    private static final String PROXIMITY_DATA_PATH = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/proximity_test_data.n3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProximityPolicy() {
        this.load(PROXIMITY_POLICY_PATH);
        String policyUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/ProximityTestPolicy";
        Set policies = this.loader.loadPolicies(policyUri);
        Assert.assertEquals((long)1L, (long)policies.size());
        DynamicPolicy policy = (DynamicPolicy)policies.iterator().next();
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertTrue((policy.getRules().size() == 1 ? 1 : 0) != 0);
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)1L, (long)rule.getChecksCount());
        Model targetModel = ModelFactory.createDefaultModel();
        try {
            targetModel.enterCriticalSection(false);
            targetModel.read(PROXIMITY_DATA_PATH);
        }
        finally {
            targetModel.leaveCriticalSection();
        }
        ObjectPropertyStatementAccessObject ao = new ObjectPropertyStatementAccessObject(targetModel, "test:publication", null, null);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.EDIT);
        ar.setEditorUris(new HashSet<String>(Arrays.asList("test:bob")));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.EDIT);
        ar.setEditorUris(new HashSet<String>(Arrays.asList("test:alice")));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar = new TestAuthorizationRequest((AccessObject)ao, AccessOperation.EDIT);
    }
}

