/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.rules.AccessRule;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SimplePermissionTemplateTest
extends PolicyTest {
    public static final String ADMIN_SIMPLE_PERMISSIONS_PATH = "simple_permissions_admin";
    public static final String CURATOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_curator";
    public static final String EDITOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_editor";
    public static final String SELF_EDITOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_self_editor";
    public static final String PUBLIC_SIMPLE_PERMISSIONS_PATH = "simple_permissions_public";
    public static final String TEMPLATE_PATH = "template_simple_permissions";

    @Test
    public void testAdminSimplePermissionPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_admin.n3");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/simple-permissions/AdminDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#SeeSiteAdminPage");
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testCuratorSimplePermissionPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_curator.n3");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/simple-permissions/CuratorDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#EditOntology");
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testEditorSimplePermissionPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_editor.n3");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/simple-permissions/EditorDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#DoBackEndEditing");
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testSelfEditorSimplePermissionPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_self_editor.n3");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/simple-permissions/SelfEditorDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#DoFrontEndEditing");
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testPublicSimplePermissionPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_public.n3");
        String dataSetUri = "https://vivoweb.org/ontology/vitro-application/auth/individual/simple-permissions/PublicDataSet";
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#QueryFullModel");
        ar.setRoleUris(Arrays.asList(""));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Test
    public void testCustomRole() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        PolicyTemplateController.createRoleDataSets((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        String dataSetUri = this.loader.getDataSetUriByKey(new String[]{AccessObjectType.NAMED_OBJECT.toString(), AccessOperation.EXECUTE.toString(), "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM"});
        Assert.assertTrue((dataSetUri != null ? 1 : 0) != 0);
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1000L, (long)policy.getPriority());
        Assert.assertEquals((long)1L, (long)policy.getRules().size());
        AccessRule rule = (AccessRule)policy.getRules().iterator().next();
        Assert.assertEquals((Object)true, (Object)rule.isAllowMatched());
        Assert.assertEquals((long)4L, (long)rule.getChecksCount());
        TestAuthorizationRequest ar = new TestAuthorizationRequest("java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#QueryFullModel");
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM"));
        Assert.assertEquals((Object)DecisionResult.AUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }
}

