/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.NamedKeyComponent;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.IndividualAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.NamedAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SuppressDisplayIndividualPageByUriTemplateTest
extends PolicyTest {
    private static final String TEST_ENTITY = "test:entity";
    public static final String POLICY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_suppress_display_individual_page_by_uri.n3";
    @Parameterized.Parameter(value=0)
    public AccessOperation ao;
    @Parameterized.Parameter(value=1)
    public AccessObjectType type;
    @Parameterized.Parameter(value=2)
    public String roleUri;
    @Parameterized.Parameter(value=3)
    public int rulesCount;
    @Parameterized.Parameter(value=4)
    public Set<Integer> attrCount;

    @Test
    public void testLoadPolicy() {
        this.load(POLICY_PATH);
        if (this.roleUri.equals("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM")) {
            PolicyTemplateController.createRoleDataSets((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        }
        EntityPolicyController.grantAccess((String)TEST_ENTITY, (AccessObjectType)this.type, (AccessOperation)this.ao, (String)this.roleUri, (String[])new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString()});
        String dataSetUri = this.loader.getDataSetUriByKey(new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString(), this.ao.toString(), this.type.toString(), this.roleUri});
        Assert.assertFalse((dataSetUri == null ? 1 : 0) != 0);
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2000L, (long)policy.getPriority());
        this.countRulesAndAttributes(policy, 1, Collections.singleton(4));
        this.policyDeniesAccess(policy);
        this.policyNotAffectsOtherTypes(policy);
        this.policyNotAffectsOtherEntities(policy);
        this.policyNotAffectsOtherOperations(policy);
        this.policyNotAffectsOtherRoles(policy);
    }

    private void policyNotAffectsOtherRoles(DynamicPolicy policy) {
        IndividualAccessObject object = new IndividualAccessObject(TEST_ENTITY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri + "_NOT_EXISTS"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherEntities(DynamicPolicy policy) {
        IndividualAccessObject object = new IndividualAccessObject("test:anothe_entity");
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherOperations(DynamicPolicy policy) {
        IndividualAccessObject object = new IndividualAccessObject(TEST_ENTITY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, AccessOperation.ADD);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherTypes(DynamicPolicy policy) {
        NamedAccessObject object = new NamedAccessObject(TEST_ENTITY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyDeniesAccess(DynamicPolicy policy) {
        IndividualAccessObject object = new IndividualAccessObject(TEST_ENTITY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest((AccessObject)object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> requests() {
        return Arrays.asList({AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)}, {AccessOperation.DISPLAY, AccessObjectType.INDIVIDUAL, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", 1, SuppressDisplayIndividualPageByUriTemplateTest.num(4)});
    }

    private static Set<Integer> num(int i) {
        return Collections.singleton(i);
    }
}

