/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.NamedKeyComponent;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.DataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.FauxDataPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.FauxObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.objects.ObjectPropertyStatementAccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.DecisionResult;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.TestAuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SuppressDisplayNotRelatedPropertyByUriTemplateTest
extends PolicyTest {
    public static final String POLICY_PATH = "../home/src/main/resources/rdf/accessControl/firsttime/template_suppress_display_not_related_property_by_uri.n3";
    public static final String TEST_DATA = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/rules/suppress_display_test_data.n3";
    private static final String TEST_ENTITY = "test:alice";
    private static final String OBJECT_ENTITY = "test:orange";
    private static final String TEST_PROPERTY = "test:has";
    private static final String OTHER_PROPERTY = "test:seen";
    @Parameterized.Parameter(value=0)
    public AccessOperation ao;
    @Parameterized.Parameter(value=1)
    public AccessObjectType type;
    @Parameterized.Parameter(value=2)
    public String roleUri;
    @Parameterized.Parameter(value=3)
    public int rulesCount;
    @Parameterized.Parameter(value=4)
    public Set<Integer> attrCount;

    @Test
    public void testLoadPolicy() {
        this.load(POLICY_PATH);
        OntModel dataModel = VitroModelFactory.createOntologyModel();
        try {
            dataModel.enterCriticalSection(false);
            dataModel.read(TEST_DATA);
        }
        finally {
            dataModel.leaveCriticalSection();
        }
        EntityPolicyController.grantAccess((String)TEST_PROPERTY, (AccessObjectType)this.type, (AccessOperation)this.ao, (String)this.roleUri, (String[])new String[]{NamedKeyComponent.NOT_RELATED.toString(), NamedKeyComponent.SUPPRESSION_BY_URI.toString()});
        String dataSetUri = this.loader.getDataSetUriByKey(new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString(), NamedKeyComponent.NOT_RELATED.toString(), this.ao.toString(), this.type.toString(), this.roleUri});
        DynamicPolicy policy = this.loader.loadPolicyFromTemplateDataSet(dataSetUri);
        Assert.assertTrue((policy != null ? 1 : 0) != 0);
        Assert.assertEquals((long)5000L, (long)policy.getPriority());
        this.countRulesAndAttributes(policy, 1, Collections.singleton(6));
        this.policyDeniesAccess(policy, dataModel);
        this.policyNotAffectsOtherTypes(policy, dataModel);
        this.policyNotAffectsOtherEntities(policy, dataModel);
        this.policyNotAffectsOtherOperations(policy, dataModel);
        this.policyNotAffectsOtherRoles(policy, dataModel);
        this.policyNotAffectsRelatedIndividuals(policy, dataModel);
    }

    private void policyNotAffectsRelatedIndividuals(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getAccessObject(targetModel, TEST_PROPERTY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        ar.setEditorUris(new HashSet<String>(Arrays.asList(TEST_ENTITY)));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherRoles(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getAccessObject(targetModel, TEST_PROPERTY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, this.ao);
        ar.setRoleUris(Arrays.asList("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherOperations(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getAccessObject(targetModel, TEST_PROPERTY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, AccessOperation.PUBLISH);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherEntities(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getAccessObject(targetModel, OTHER_PROPERTY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyNotAffectsOtherTypes(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getWrongAccessObject(targetModel);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.INCONCLUSIVE, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private void policyDeniesAccess(DynamicPolicy policy, OntModel targetModel) {
        AccessObject object = this.getAccessObject(targetModel, TEST_PROPERTY);
        TestAuthorizationRequest ar = new TestAuthorizationRequest(object, this.ao);
        ar.setRoleUris(Arrays.asList(this.roleUri));
        Assert.assertEquals((Object)DecisionResult.UNAUTHORIZED, (Object)policy.decide((AuthorizationRequest)ar).getDecisionResult());
    }

    private AccessObject getWrongAccessObject(OntModel targetModel) {
        FauxProperty fauxProperty = new FauxProperty(TEST_ENTITY, TEST_PROPERTY, "");
        fauxProperty.setConfigUri(TEST_PROPERTY);
        switch (this.type) {
            case OBJECT_PROPERTY: {
                return new DataPropertyStatementAccessObject(targetModel, TEST_ENTITY, TEST_PROPERTY, "test");
            }
            case DATA_PROPERTY: {
                return new ObjectPropertyStatementAccessObject((Model)targetModel, TEST_ENTITY, new Property(TEST_PROPERTY), OBJECT_ENTITY);
            }
            case FAUX_OBJECT_PROPERTY: {
                return new FauxDataPropertyStatementAccessObject(targetModel, TEST_ENTITY, fauxProperty, "test");
            }
            case FAUX_DATA_PROPERTY: {
                return new FauxObjectPropertyStatementAccessObject((Model)targetModel, TEST_ENTITY, fauxProperty, OBJECT_ENTITY);
            }
        }
        return null;
    }

    private AccessObject getAccessObject(OntModel targetModel, String property) {
        FauxProperty fauxProperty = new FauxProperty(TEST_ENTITY, property, "");
        fauxProperty.setConfigUri(property);
        switch (this.type) {
            case DATA_PROPERTY: {
                return new DataPropertyStatementAccessObject(targetModel, TEST_ENTITY, property, "test");
            }
            case OBJECT_PROPERTY: {
                return new ObjectPropertyStatementAccessObject((Model)targetModel, TEST_ENTITY, new Property(property), OBJECT_ENTITY);
            }
            case FAUX_DATA_PROPERTY: {
                return new FauxDataPropertyStatementAccessObject(targetModel, TEST_ENTITY, fauxProperty, "test");
            }
            case FAUX_OBJECT_PROPERTY: {
                return new FauxObjectPropertyStatementAccessObject((Model)targetModel, TEST_ENTITY, fauxProperty, OBJECT_ENTITY);
            }
        }
        return null;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> requests() {
        return Arrays.asList({AccessOperation.DISPLAY, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, SuppressDisplayNotRelatedPropertyByUriTemplateTest.num(5)}, {AccessOperation.DISPLAY, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, SuppressDisplayNotRelatedPropertyByUriTemplateTest.num(5)}, {AccessOperation.DISPLAY, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, SuppressDisplayNotRelatedPropertyByUriTemplateTest.num(5)}, {AccessOperation.DISPLAY, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 1, SuppressDisplayNotRelatedPropertyByUriTemplateTest.num(5)});
    }

    private static Set<Integer> num(int i) {
        return Collections.singleton(i);
    }
}

