/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.DynamicPolicy;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UpdateRelatedAllowedPropertiesPolicyTemplateTest
extends PolicyTest {
    @Parameterized.Parameter(value=0)
    public AccessOperation ao;
    @Parameterized.Parameter(value=1)
    public AccessObjectType type;
    @Parameterized.Parameter(value=2)
    public String roleUri;
    @Parameterized.Parameter(value=3)
    public int rulesCount;
    @Parameterized.Parameter(value=4)
    public Set<Integer> attrCount;

    @Test
    public void testPolicy() {
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_update_related_allowed_property.n3");
        EntityPolicyController.grantAccess((String)"test:entity", (AccessObjectType)this.type, (AccessOperation)this.ao, (String)this.roleUri, (String[])new String[0]);
        DynamicPolicy policy = null;
        String dataSet = this.loader.getDataSetUriByKey(new String[]{this.ao.toString(), this.type.toString(), this.roleUri});
        policy = this.loader.loadPolicyFromTemplateDataSet(dataSet);
        this.countRulesAndAttributes(policy, this.rulesCount, this.attrCount);
        Set values = this.loader.getDataSetValues(this.ao, this.type, this.roleUri);
        Assert.assertFalse((boolean)values.isEmpty());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> requests() {
        return Arrays.asList({AccessOperation.ADD, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.ADD, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.ADD, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.ADD, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.DROP, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.DROP, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.DROP, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.DROP, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.EDIT, AccessObjectType.OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.EDIT, AccessObjectType.DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.EDIT, AccessObjectType.FAUX_OBJECT_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)}, {AccessOperation.EDIT, AccessObjectType.FAUX_DATA_PROPERTY, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 3, UpdateRelatedAllowedPropertiesPolicyTemplateTest.num(4, 5)});
    }

    private static Set<Integer> num(Integer ... i) {
        return new HashSet<Integer>(Arrays.asList(i));
    }
}

