/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.rules;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.MutableAttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AccessObjectUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.CheckType;
import edu.cornell.mannlib.vitro.webapp.auth.rules.FastFailAccessRule;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AccessRuleTest {
    @Test
    public void testAttributeOrderByComputationalCost() {
        FastFailAccessRule rule = new FastFailAccessRule();
        Check equalsAttribute = this.uriCheck("test:equals");
        equalsAttribute.setType(CheckType.EQUALS);
        Check notEqualsAttribute = this.uriCheck("test:not-equals");
        notEqualsAttribute.setType(CheckType.NOT_EQUALS);
        Check oneOfAttribute = this.uriCheck("test:one-of");
        oneOfAttribute.setType(CheckType.ONE_OF);
        Check notOneOfAttribute = this.uriCheck("test:not-one-of");
        notOneOfAttribute.setType(CheckType.NOT_ONE_OF);
        Check sparqlResultsContainAttribute = this.uriCheck("test:sparql-results-contain");
        sparqlResultsContainAttribute.setType(CheckType.SPARQL_SELECT_QUERY_RESULTS_CONTAIN);
        Check sparqlResultsNotContainAttribute = this.uriCheck("test:sparql-results-not-contain");
        sparqlResultsNotContainAttribute.setType(CheckType.SPARQL_SELECT_QUERY_RESULTS_NOT_CONTAIN);
        rule.addCheck(notOneOfAttribute);
        rule.addCheck(oneOfAttribute);
        rule.addCheck(sparqlResultsContainAttribute);
        rule.addCheck(equalsAttribute);
        rule.addCheck(notEqualsAttribute);
        rule.addCheck(sparqlResultsNotContainAttribute);
        List list = rule.getChecks();
        Assert.assertEquals((Object)equalsAttribute.getUri(), (Object)((Check)list.get(0)).getUri());
        Assert.assertEquals((Object)notEqualsAttribute.getUri(), (Object)((Check)list.get(1)).getUri());
        Assert.assertEquals((Object)oneOfAttribute.getUri(), (Object)((Check)list.get(2)).getUri());
        Assert.assertEquals((Object)notOneOfAttribute.getUri(), (Object)((Check)list.get(3)).getUri());
        Assert.assertEquals((Object)sparqlResultsContainAttribute.getUri(), (Object)((Check)list.get(4)).getUri());
        Assert.assertEquals((Object)sparqlResultsNotContainAttribute.getUri(), (Object)((Check)list.get(5)).getUri());
    }

    private AttributeValueSet value(String value) {
        return new MutableAttributeValueSet(value);
    }

    private Check uriCheck(String uri) {
        return new AccessObjectUriCheck(uri, this.value("test:objectUri"));
    }
}

