/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyStore;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.AuthenticatorStub;
import edu.cornell.mannlib.vitro.webapp.controller.edit.Authenticate;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.IndividualDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.i18n.I18nStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletConfigStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpServletResponseStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class AuthenticateTest
extends AbstractTestClass {
    private AuthenticatorStub.Factory authenticatorFactory;
    private AuthenticatorStub authenticator;
    private ServletContextStub servletContext;
    private WebappDaoFactoryStub webappDaoFactory;
    private UserAccountsDaoStub userAccountsDao;
    private IndividualDaoStub individualDao;
    private ServletConfigStub servletConfig;
    private HttpSessionStub session;
    private HttpServletRequestStub request;
    private HttpServletResponseStub response;
    private Authenticate auth;
    private LoginProcessBean initialProcessBean;
    private static final String NEW_DBA_NAME = "new_dba_name";
    private static final String NEW_DBA_PW = "new_dba_pw";
    private static final UserInfo NEW_DBA = new UserInfo("new_dba_name", "new_dba_uri", "new_dba_pw", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 0);
    private static final String OLD_DBA_NAME = "old_dba_name";
    private static final String OLD_DBA_PW = "old_dba_pw";
    private static final String OLD_DBA_URI = "old_dba_uri";
    private static final UserInfo OLD_DBA = new UserInfo("old_dba_name", "old_dba_uri", "old_dba_pw", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN", 5);
    private static final String OLD_SELF_NAME = "old_self_name";
    private static final String OLD_SELF_PW = "old_self_pw";
    private static final UserInfo OLD_SELF = new UserInfo("old_self_name", "old_self_uri", "old_self_pw", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 100);
    private static final String OLD_STRANGER_NAME = "old_stranger_name";
    private static final String OLD_STRANGER_PW = "stranger_pw";
    private static final UserInfo OLD_STRANGER = new UserInfo("old_stranger_name", "old_stranger_uri", "stranger_pw", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR", 20);
    private static final String URL_LOGIN = "/vivo/login";
    private static final String URL_WIDGET = "/vivo/widgetPage";
    private static final String URL_RESTRICTED = "/vivo/resrictedPage";
    private static final String URL_WITH_LINK = "/vivo/linkPage";
    private static final String URL_HOME = "/vivo";
    private static final String URL_SITE_ADMIN = "/vivo/siteAdmin";
    private static final String URL_SELF_PROFILE = "/vivo/individual?uri=old_self_associated_uri";
    private static final String URL_SOMEWHERE_ELSE = "/vivo/somewhereElse";
    private static final String NO_USER = "";
    private static final String NO_MSG = "";
    private static List<UserAccount> userAccounts = new ArrayList<UserAccount>();

    @BeforeClass
    public static void prepareUserAccounts() {
        userAccounts.add(AuthenticateTest.createUserFromUserInfo(NEW_DBA));
        userAccounts.add(AuthenticateTest.createUserFromUserInfo(OLD_DBA));
        userAccounts.add(AuthenticateTest.createUserFromUserInfo(OLD_SELF));
        userAccounts.add(AuthenticateTest.createUserFromUserInfo(OLD_STRANGER));
    }

    @Before
    public void setup() throws Exception {
        I18nStub.setup();
        this.authenticatorFactory = new AuthenticatorStub.Factory();
        this.authenticator = this.authenticatorFactory.getInstance(this.request);
        for (UserAccount userAccount : userAccounts) {
            this.authenticator.addUser(userAccount);
        }
        this.authenticator.setAssociatedUri(AuthenticateTest.OLD_SELF.username, "old_self_associated_uri");
        this.servletContext = new ServletContextStub();
        this.servletContext.setAttribute(AuthenticatorStub.FACTORY_ATTRIBUTE_NAME, this.authenticatorFactory);
        PermissionSet adminPermissionSet = new PermissionSet();
        adminPermissionSet.setUri("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        adminPermissionSet.setPermissionUris(Collections.singleton((String)SimplePermission.SEE_SITE_ADMIN_PAGE.ACTION.getObject().getUri().get()));
        this.userAccountsDao = new UserAccountsDaoStub();
        this.userAccountsDao.addPermissionSet(adminPermissionSet);
        for (UserAccount account : userAccounts) {
            this.userAccountsDao.addUser(account);
        }
        this.individualDao = new IndividualDaoStub();
        this.webappDaoFactory = new WebappDaoFactoryStub();
        this.webappDaoFactory.setUserAccountsDao(this.userAccountsDao);
        this.webappDaoFactory.setIndividualDao(this.individualDao);
        ModelAccessFactoryStub modelAccessFactoryStub = new ModelAccessFactoryStub();
        modelAccessFactoryStub.get(this.servletContext).setWebappDaoFactory(this.webappDaoFactory);
        AuthenticateTest.setLoggerLevel(PolicyStore.class, Level.WARN);
        this.servletConfig = new ServletConfigStub();
        this.servletConfig.setServletContext(this.servletContext);
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.servletContext);
        this.request = new HttpServletRequestStub();
        this.request.setSession(this.session);
        this.request.setRequestUrlByParts("http://this.that", URL_HOME, "/authenticate", null);
        this.request.setMethod("POST");
        this.response = new HttpServletResponseStub();
        this.auth = new Authenticate();
        this.auth.init((ServletConfig)this.servletConfig);
        AuthenticateTest.setLoggerLevel(ConfigurationProperties.class, Level.WARN);
        new ConfigurationPropertiesStub().setBean(this.servletContext);
    }

    private static UserAccount createUserFromUserInfo(UserInfo userInfo) {
        UserAccount user = new UserAccount();
        user.setEmailAddress(userInfo.username);
        user.setUri(userInfo.uri);
        user.setPermissionSetUris(userInfo.permissionSetUris);
        user.setArgon2Password(AuthenticatorStub.applyArgon2iEncodingStub(userInfo.password));
        user.setMd5Password("");
        user.setLoginCount(userInfo.loginCount);
        user.setPasswordChangeRequired(Boolean.valueOf(userInfo.loginCount == 0));
        return user;
    }

    @Test
    public void enterFromALoginLink() {
        this.setRequestFromLoginLink(URL_WITH_LINK);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirect(URL_LOGIN);
    }

    @Test
    public void enterFromABookmarkOfTheLoginLink() {
        this.setRequestFromLoginLink(null);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "", URL_LOGIN, URL_LOGIN);
        this.assertRedirect(URL_LOGIN);
    }

    @Test
    public void enterFromARestrictedPage() {
        this.setRequestFromRestrictedPage(URL_RESTRICTED);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "", URL_LOGIN, URL_RESTRICTED);
        this.assertRedirect(URL_LOGIN);
    }

    @Test
    public void enterFromAWidgetPage() {
        this.setRequestFromWidgetPage(URL_WIDGET);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "", URL_WIDGET, URL_WIDGET);
        this.assertRedirect(URL_WIDGET);
    }

    @Test
    public void enterFromTheLoginPage() {
        this.setRequestFromWidgetPage(URL_LOGIN);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "", URL_LOGIN, URL_LOGIN);
        this.assertRedirect(URL_LOGIN);
    }

    @Ignore
    @Test
    public void restartFromALoginLink() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "username", URL_LOGIN, URL_SOMEWHERE_ELSE);
        this.enterFromALoginLink();
    }

    @Ignore
    @Test
    public void restartFromABookmarkOfTheLoginLink() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "username", URL_LOGIN, URL_SOMEWHERE_ELSE);
        this.enterFromABookmarkOfTheLoginLink();
    }

    @Ignore
    @Test
    public void restartFromARestrictedPage() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "username", URL_LOGIN, URL_SOMEWHERE_ELSE);
        this.enterFromARestrictedPage();
    }

    @Ignore
    @Test
    public void restartFromADifferentWidgetPage() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "username", URL_LOGIN, URL_SOMEWHERE_ELSE);
        this.enterFromAWidgetPage();
    }

    @Ignore
    @Test
    public void restartFromTheLoginPageWhenWeWereUsingAWidgetPage() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "username", URL_SOMEWHERE_ELSE, URL_SOMEWHERE_ELSE);
        this.enterFromTheLoginPage();
    }

    @Test
    public void loggingInNoUsername() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "", "", "error_no_email_address", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void loggingInUsernameNotRecognized() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword("unknownBozo", null);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, "unknownBozo", "", "error_incorrect_credentials", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void loggingInNoPassword() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(NEW_DBA_NAME, null);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, NEW_DBA_NAME, "", "error_no_password", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void loggingInPasswordIsIncorrect() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(NEW_DBA_NAME, "bogus_password");
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.LOGGING_IN, NEW_DBA_NAME, "", "error_incorrect_credentials", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void loggingInSuccessful() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(OLD_DBA_NAME, OLD_DBA_PW);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(OLD_DBA_NAME);
        this.assertRedirectToAfterLoginPage();
    }

    @Test
    public void loggingInForcesPasswordChange() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(NEW_DBA_NAME, NEW_DBA_PW);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, "", "", URL_LOGIN, URL_WITH_LINK);
        this.assertNewLoginSessions(new String[0]);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void changingPasswordCancel() {
        this.setProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, URL_LOGIN, URL_WITH_LINK);
        this.setCancel();
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(new String[0]);
        this.assertRedirectToCancelUrl();
    }

    @Test
    public void changingPasswordWrongLength() {
        this.setProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, URL_LOGIN, URL_WITH_LINK);
        this.setNewPasswordAttempt("HI", "HI");
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, "", "error_password_length", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void changingPasswordDontMatch() {
        this.setProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, URL_LOGIN, URL_WITH_LINK);
        this.setNewPasswordAttempt("LongEnough", "DoesNotMatch");
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, "", "error_passwords_dont_match", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void changingPasswordSameAsBefore() {
        this.setProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, URL_LOGIN, URL_WITH_LINK);
        this.setNewPasswordAttempt(NEW_DBA_PW, NEW_DBA_PW);
        this.doTheRequest();
        this.assertProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, "", "error_previous_password", URL_LOGIN, URL_WITH_LINK);
        this.assertRedirectToLoginProcessPage();
    }

    @Test
    public void changingPasswordSuccess() {
        this.setProcessBean(LoginProcessBean.State.FORCED_PASSWORD_CHANGE, NEW_DBA_NAME, URL_LOGIN, URL_WITH_LINK);
        this.setNewPasswordAttempt("NewPassword", "NewPassword");
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(NEW_DBA_NAME);
        this.assertPasswordChanges(NEW_DBA_NAME, "NewPassword");
        this.assertRedirectToAfterLoginPage();
    }

    @Test
    public void alreadyLoggedIn() {
        LoginStatusBean statusBean = new LoginStatusBean(OLD_DBA_URI, LoginStatusBean.AuthenticationSource.INTERNAL);
        LoginStatusBean.setBean((HttpSession)this.session, (LoginStatusBean)statusBean);
        this.setRequestFromLoginLink(URL_WITH_LINK);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(new String[0]);
        this.assertRedirect(URL_WITH_LINK);
    }

    @Test
    public void exitSelfEditor() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(OLD_SELF_NAME, OLD_SELF_PW);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(OLD_SELF_NAME);
        this.assertRedirect(URL_SELF_PROFILE);
    }

    @Test
    public void exitUnrecognizedSelfEditor() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_WITH_LINK);
        this.setLoginNameAndPassword(OLD_STRANGER_NAME, OLD_STRANGER_PW);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(OLD_STRANGER_NAME);
        this.assertRedirect(URL_WITH_LINK);
    }

    @Test
    public void exitDbaNormal() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_RESTRICTED);
        this.setLoginNameAndPassword(OLD_DBA_NAME, OLD_DBA_PW);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(OLD_DBA_NAME);
        this.assertRedirect(URL_RESTRICTED);
    }

    @Ignore
    @Test
    public void exitDbaFromLoginPage() {
        this.setProcessBean(LoginProcessBean.State.LOGGING_IN, "", URL_LOGIN, URL_LOGIN);
        this.setLoginNameAndPassword(OLD_DBA_NAME, OLD_DBA_PW);
        this.doTheRequest();
        this.assertNoProcessBean();
        this.assertNewLoginSessions(OLD_DBA_NAME);
        this.assertRedirect(URL_SITE_ADMIN);
    }

    private void setRequestFromLoginLink(String urlWithLink) {
        this.request.addParameter("return", "");
        this.request.setHeader("referer", urlWithLink);
    }

    private void setRequestFromRestrictedPage(String urlRestricted) {
        this.request.addParameter("afterLogin", urlRestricted);
        this.request.setHeader("referer", urlRestricted);
    }

    private void setRequestFromWidgetPage(String urlWidget) {
        this.request.setHeader("referer", urlWidget);
    }

    private void setProcessBean(LoginProcessBean.State state, String username, String loginProcessUrl, String afterLoginUrl) {
        LoginProcessBean bean = LoginProcessBean.getBean((HttpServletRequest)this.request);
        bean.setState(state);
        bean.setUsername(username);
        bean.setLoginPageUrl(loginProcessUrl);
        bean.setAfterLoginUrl(afterLoginUrl);
        this.initialProcessBean = bean;
    }

    private void setLoginNameAndPassword(String loginName, String password) {
        this.request.addParameter("loginName", loginName);
        this.request.addParameter("loginPassword", password);
    }

    private void setCancel() {
        this.request.addParameter("cancel", "true");
    }

    private void setNewPasswordAttempt(String newPassword, String confirmPassword) {
        this.request.addParameter("newPassword", newPassword);
        this.request.addParameter("confirmPassword", confirmPassword);
    }

    private void doTheRequest() {
        this.auth.doPost((HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    private void assertNoProcessBean() {
        if (LoginProcessBean.isBean((HttpServletRequest)this.request)) {
            Assert.fail((String)("Process bean: expected <null>, but was <" + LoginProcessBean.getBean((HttpServletRequest)this.request) + ">"));
        }
    }

    private void assertProcessBean(LoginProcessBean.State state, String username, String infoMessage, String errorMessage, String loginProcessUrl, String afterLoginUrl) {
        if (!LoginProcessBean.isBean((HttpServletRequest)this.request)) {
            Assert.fail((String)"login process bean is null");
        }
        LoginProcessBean bean = LoginProcessBean.getBean((HttpServletRequest)this.request);
        Assert.assertEquals((String)"state", (Object)state, (Object)bean.getState());
        Assert.assertEquals((String)"username", (Object)username, (Object)bean.getUsername());
        Assert.assertEquals((String)"info message", (Object)infoMessage, (Object)bean.getInfoMessageAndClear());
        Assert.assertEquals((String)"error message", (Object)errorMessage, (Object)bean.getErrorMessageAndClear());
        Assert.assertEquals((String)"login process URL", (Object)loginProcessUrl, (Object)bean.getLoginPageUrl());
        Assert.assertEquals((String)"after login URL", (Object)afterLoginUrl, (Object)bean.getAfterLoginUrl());
    }

    private void assertRedirect(String path) {
        if (path.startsWith("http://")) {
            Assert.assertEquals((String)"absolute redirect", (Object)path, (Object)this.response.getRedirectLocation());
        } else {
            Assert.assertEquals((String)"relative redirect", (Object)path, (Object)this.response.getRedirectLocation());
        }
    }

    private void assertRedirectToLoginProcessPage() {
        this.assertRedirect(LoginProcessBean.getBean((HttpServletRequest)this.request).getLoginPageUrl());
    }

    private void assertRedirectToAfterLoginPage() {
        Assert.assertNotNull((String)"No reference to the initial LoginProcessBean", (Object)this.initialProcessBean);
        this.assertRedirect(this.initialProcessBean.getAfterLoginUrl());
    }

    private void assertRedirectToCancelUrl() {
        String afterLoginUrl = this.initialProcessBean.getAfterLoginUrl();
        if (afterLoginUrl == null || afterLoginUrl.equals(URL_LOGIN)) {
            this.assertRedirect(URL_HOME);
        } else {
            this.assertRedirect(afterLoginUrl);
        }
    }

    private void assertNewLoginSessions(String ... usernames) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(usernames));
        HashSet<String> actualRecorded = new HashSet<String>(this.authenticator.getRecordedLoginUsernames());
        Assert.assertEquals((String)"recorded logins", expected, actualRecorded);
    }

    private void assertPasswordChanges(String ... strings) {
        if (strings.length % 2 != 0) {
            throw new RuntimeException("supply even number of args: username and password");
        }
        HashMap<String, String> expected = new HashMap<String, String>();
        for (int i = 0; i < strings.length; i += 2) {
            expected.put(strings[i], strings[i + 1]);
        }
        Assert.assertEquals((String)"password changes", expected, this.authenticator.getNewPasswordMap());
    }

    private static class UserInfo {
        final String username;
        final String uri;
        final String password;
        final Set<String> permissionSetUris;
        final int loginCount;

        public UserInfo(String username, String uri, String password, String roleUri, int loginCount) {
            this.username = username;
            this.uri = uri;
            this.password = password;
            this.permissionSetUris = Collections.singleton(roleUri);
            this.loginCount = loginCount;
        }

        public String toString() {
            return "UserInfo[username=" + this.username + ", uri=" + this.uri + ", password=" + this.password + ", roleUri=" + this.permissionSetUris + ", loginCount=" + this.loginCount + "]";
        }
    }
}

