/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.IndividualFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.jga.fn.UnaryFunctor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.beans.IndividualStub;

public class IndividualFilteringByStatementTest
extends AbstractTestClass {
    private static final String URI_INDIVIDUAL_SPECIAL = "specialUri";
    private static final String URI_SUBJECT = "subject";
    private static final String PROPERTY_DATA_HIDDEN = "hiddenDataProperty";
    private static final String PROPERTY_DATA_VISIBLE = "visibleDataProperty";
    private static final String PROPERTY_DATA_MAYBE = "maybeDataProperty";
    private static final String PROPERTY_OBJECT_HIDDEN = "hiddenObjectProperty";
    private static final String PROPERTY_OBJECT_VISIBLE = "visibleObjectProperty";
    private static final String PROPERTY_OBJECT_MAYBE = "maybeObjectProperty";
    private static final String VALUE_HIDDEN_DATA_SPECIAL = "hidden data on special";
    private static final String VALUE_VISIBLE_DATA_SPECIAL = "visible data on special";
    private static final String VALUE_MAYBE_DATA_SPECIAL = "maybe data on special";
    private static final String URI_HIDDEN_OBJECT_SPECIAL = "object://hidden_on_special";
    private static final String URI_VISIBLE_OBJECT_SPECIAL = "object://visible_on_special";
    private static final String URI_MAYBE_OBJECT_SPECIAL = "object://maybe_on_special";
    private static final String VALUE_HIDDEN_DATA_ORDINARY = "hidden data on ordinary";
    private static final String VALUE_VISIBLE_DATA_ORDINARY = "visible data on ordinary";
    private static final String VALUE_MAYBE_DATA_ORDINARY = "maybe data on ordinary";
    private static final String URI_HIDDEN_OBJECT_ORDINARY = "object://hidden_on_ordinary";
    private static final String URI_VISIBLE_OBJECT_ORDINARY = "object://visible_on_ordinary";
    private static final String URI_MAYBE_OBJECT_ORDINARY = "object://maybe_on_ordinary";
    private static final String FAUX_DOMAIN_VISIBLE = "faux://visibleDomain";
    private static final String FAUX_RANGE_VISIBLE = "faux://visibleRange";
    private static final String FAUX_DOMAIN_HIDDEN = "faux://hiddenDomain";
    private static final String FAUX_RANGE_HIDDEN = "faux://hiddenRange";
    private static final String URI_FAUX_VISIBLE_ORDINARY = "object://faux_visible_on_ordinary";
    private static final String URI_FAUX_HIDDEN_ORDINARY = "object://faux_hidden_on_ordinary";
    private IndividualStub indSpecial;
    private IndividualStub indOrdinary;
    private Individual filteredSpecial;
    private Individual filteredOrdinary;

    @Before
    public void createIndividuals() {
        this.indSpecial = new IndividualStub(URI_INDIVIDUAL_SPECIAL);
        this.indSpecial.addDataPropertyStatement(PROPERTY_DATA_HIDDEN, VALUE_HIDDEN_DATA_SPECIAL);
        this.indSpecial.addDataPropertyStatement(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_SPECIAL);
        this.indSpecial.addDataPropertyStatement(PROPERTY_DATA_MAYBE, VALUE_MAYBE_DATA_SPECIAL);
        this.indSpecial.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_HIDDEN), URI_HIDDEN_OBJECT_SPECIAL);
        this.indSpecial.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_VISIBLE), URI_VISIBLE_OBJECT_SPECIAL);
        this.indSpecial.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_MAYBE), URI_MAYBE_OBJECT_SPECIAL);
        this.filteredSpecial = new IndividualFiltering((Individual)this.indSpecial, (VitroFilters)new IndividualBasedFilter());
        this.indOrdinary = new IndividualStub("someOtherUri");
        this.indOrdinary.addDataPropertyStatement(PROPERTY_DATA_HIDDEN, VALUE_HIDDEN_DATA_ORDINARY);
        this.indOrdinary.addDataPropertyStatement(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_ORDINARY);
        this.indOrdinary.addDataPropertyStatement(PROPERTY_DATA_MAYBE, VALUE_MAYBE_DATA_ORDINARY);
        this.indOrdinary.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_HIDDEN), URI_HIDDEN_OBJECT_ORDINARY);
        this.indOrdinary.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_VISIBLE), URI_VISIBLE_OBJECT_ORDINARY);
        this.indOrdinary.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_MAYBE), URI_MAYBE_OBJECT_ORDINARY);
        this.filteredOrdinary = new IndividualFiltering((Individual)this.indOrdinary, (VitroFilters)new IndividualBasedFilter());
    }

    private ObjectProperty property(String propertyUri) {
        return this.property(propertyUri, AccessObject.SOME_URI, AccessObject.SOME_URI);
    }

    private ObjectProperty property(String propertyUri, String domainUri, String rangeUri) {
        ObjectProperty op = new ObjectProperty();
        op.setURI(propertyUri);
        op.setDomainVClassURI(domainUri);
        op.setRangeVClassURI(rangeUri);
        return op;
    }

    @Test
    public void onSpecial_getDataPropertyStatements() {
        List<DataPropertyStatement> expected = this.dpsList(this.filteredSpecial, this.dps(PROPERTY_DATA_MAYBE, VALUE_MAYBE_DATA_SPECIAL), this.dps(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_SPECIAL));
        List actual = this.filteredSpecial.getDataPropertyStatements();
        this.assertEquivalentDpsList("data property statements", expected, actual);
    }

    @Test
    public void onOrdinary_getDataPropertyStatements() {
        List<DataPropertyStatement> expected = this.dpsList(this.filteredOrdinary, this.dps(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_ORDINARY));
        List actual = this.filteredOrdinary.getDataPropertyStatements();
        this.assertEquivalentDpsList("data property statements", expected, actual);
    }

    @Test
    public void onSpecial_getDataPropertyStatementsByProperty() {
        List<DataPropertyStatement> visibleExpected = this.dpsList(this.filteredSpecial, this.dps(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_SPECIAL));
        List visibleActual = this.filteredSpecial.getDataPropertyStatements(PROPERTY_DATA_VISIBLE);
        this.assertEquivalentDpsList("visible", visibleExpected, visibleActual);
        List<DataPropertyStatement> hiddenExpected = Collections.emptyList();
        List hiddenActual = this.filteredSpecial.getDataPropertyStatements(PROPERTY_DATA_HIDDEN);
        this.assertEquivalentDpsList("hidden", hiddenExpected, hiddenActual);
        List<DataPropertyStatement> maybeExpected = this.dpsList(this.filteredSpecial, this.dps(PROPERTY_DATA_MAYBE, VALUE_MAYBE_DATA_SPECIAL));
        List maybeActual = this.filteredSpecial.getDataPropertyStatements(PROPERTY_DATA_MAYBE);
        this.assertEquivalentDpsList("maybe", maybeExpected, maybeActual);
    }

    @Test
    public void onOrdinary_getDataPropertyStatementsByProperty() {
        List<DataPropertyStatement> visibleExpected = this.dpsList(this.filteredOrdinary, this.dps(PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_ORDINARY));
        List visibleActual = this.filteredOrdinary.getDataPropertyStatements(PROPERTY_DATA_VISIBLE);
        this.assertEquivalentDpsList("visible", visibleExpected, visibleActual);
        List<DataPropertyStatement> hiddenExpected = Collections.emptyList();
        List hiddenActual = this.filteredOrdinary.getDataPropertyStatements(PROPERTY_DATA_HIDDEN);
        this.assertEquivalentDpsList("hidden", hiddenExpected, hiddenActual);
        List<DataPropertyStatement> maybeExpected = Collections.emptyList();
        List maybeActual = this.filteredOrdinary.getDataPropertyStatements(PROPERTY_DATA_MAYBE);
        this.assertEquivalentDpsList("maybe", maybeExpected, maybeActual);
    }

    @Test
    public void onSpecial_getDataPropertyStatement() {
        DataPropertyStatement visibleExpected = this.dps(this.filteredSpecial.getURI(), PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_SPECIAL);
        DataPropertyStatement visibleActual = this.filteredSpecial.getDataPropertyStatement(PROPERTY_DATA_VISIBLE);
        this.assertEquivalentDps("visible", visibleExpected, visibleActual);
        DataPropertyStatement hiddenExpected = null;
        DataPropertyStatement hiddenActual = this.filteredSpecial.getDataPropertyStatement(PROPERTY_DATA_HIDDEN);
        this.assertEquivalentDps("hidden", hiddenExpected, hiddenActual);
        DataPropertyStatement maybeExpected = this.dps(this.filteredSpecial.getURI(), PROPERTY_DATA_MAYBE, VALUE_MAYBE_DATA_SPECIAL);
        DataPropertyStatement maybeActual = this.filteredSpecial.getDataPropertyStatement(PROPERTY_DATA_MAYBE);
        this.assertEquivalentDps("maybe", maybeExpected, maybeActual);
    }

    @Test
    public void onOrdinary_getDataPropertyStatement() {
        DataPropertyStatement visibleExpected = this.dps(this.filteredOrdinary.getURI(), PROPERTY_DATA_VISIBLE, VALUE_VISIBLE_DATA_ORDINARY);
        DataPropertyStatement visibleActual = this.filteredOrdinary.getDataPropertyStatement(PROPERTY_DATA_VISIBLE);
        this.assertEquivalentDps("visible", visibleExpected, visibleActual);
        DataPropertyStatement hiddenExpected = null;
        DataPropertyStatement hiddenActual = this.filteredOrdinary.getDataPropertyStatement(PROPERTY_DATA_HIDDEN);
        this.assertEquivalentDps("hidden", hiddenExpected, hiddenActual);
        DataPropertyStatement maybeExpected = null;
        DataPropertyStatement maybeActual = this.filteredOrdinary.getDataPropertyStatement(PROPERTY_DATA_MAYBE);
        this.assertEquivalentDps("maybe", maybeExpected, maybeActual);
    }

    @Ignore
    @Test
    public void onSpecial_getDataPropertyList() {
        Assert.fail((String)"onSpecial_getDataPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getDataPropertyList() {
        Assert.fail((String)"onOrdinary_getDataPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onSpecial_getPopulatedDataPropertyList() {
        Assert.fail((String)"onSpecial_getPopulatedDataPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getPopulatedDataPropertyList() {
        Assert.fail((String)"onOrdinary_getPopulatedDataPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onSpecial_getDataPropertyMap() {
        Assert.fail((String)"onSpecial_getDataPropertyMap not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getDataPropertyMap() {
        Assert.fail((String)"onOrdinary_getDataPropertyMap not implemented");
    }

    @Test
    public void onSpecial_getObjectPropertyStatementsByProperty() {
        List<ObjectPropertyStatement> visibleExpected = this.opsList(this.filteredSpecial, this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_SPECIAL));
        List visibleActual = this.filteredSpecial.getObjectPropertyStatements(PROPERTY_OBJECT_VISIBLE);
        this.assertEquivalentOpsList("visible", visibleExpected, visibleActual);
        List<ObjectPropertyStatement> hiddenExpected = Collections.emptyList();
        List hiddenActual = this.filteredSpecial.getObjectPropertyStatements(PROPERTY_OBJECT_HIDDEN);
        this.assertEquivalentOpsList("hidden", hiddenExpected, hiddenActual);
        List<ObjectPropertyStatement> maybeExpected = this.opsList(this.filteredSpecial, this.ops(PROPERTY_OBJECT_MAYBE, URI_MAYBE_OBJECT_SPECIAL));
        List maybeActual = this.filteredSpecial.getObjectPropertyStatements(PROPERTY_OBJECT_MAYBE);
        this.assertEquivalentOpsList("maybe", maybeExpected, maybeActual);
    }

    @Test
    public void onOrdinary_getObjectPropertyStatementsByProperty() {
        List<ObjectPropertyStatement> visibleExpected = this.opsList(this.filteredOrdinary, this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_ORDINARY));
        List visibleActual = this.filteredOrdinary.getObjectPropertyStatements(PROPERTY_OBJECT_VISIBLE);
        this.assertEquivalentOpsList("visible", visibleExpected, visibleActual);
        List<ObjectPropertyStatement> hiddenExpected = Collections.emptyList();
        List hiddenActual = this.filteredOrdinary.getObjectPropertyStatements(PROPERTY_OBJECT_HIDDEN);
        this.assertEquivalentOpsList("hidden", hiddenExpected, hiddenActual);
        List<ObjectPropertyStatement> maybeExpected = Collections.emptyList();
        List maybeActual = this.filteredOrdinary.getObjectPropertyStatements(PROPERTY_OBJECT_MAYBE);
        this.assertEquivalentOpsList("maybe", maybeExpected, maybeActual);
    }

    @Test
    public void onSpecial_getObjectPropertyStatements() {
        List<ObjectPropertyStatement> expected = this.opsList(this.filteredSpecial, this.ops(PROPERTY_OBJECT_MAYBE, URI_MAYBE_OBJECT_SPECIAL), this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_SPECIAL));
        List actual = this.filteredSpecial.getObjectPropertyStatements();
        this.assertEquivalentOpsList("object property statements", expected, actual);
    }

    @Test
    public void onOrdinary_getObjectPropertyStatements() {
        List<ObjectPropertyStatement> expected = this.opsList(this.filteredOrdinary, this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_ORDINARY));
        List actual = this.filteredOrdinary.getObjectPropertyStatements();
        this.assertEquivalentOpsList("object property statements", expected, actual);
    }

    @Ignore
    @Test
    public void onSpecial_getObjectPropertyMap() {
        Assert.fail((String)"onSpecial_getObjectPropertyMap not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getObjectPropertyMap() {
        Assert.fail((String)"onOrdinary_getObjectPropertyMap not implemented");
    }

    @Ignore
    @Test
    public void onSpecial_getObjectPropertyList() {
        Assert.fail((String)"onSpecial_getObjectPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getObjectPropertyList() {
        Assert.fail((String)"onOrdinary_getObjectPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onSpecial_getPopulatedObjectPropertyList() {
        Assert.fail((String)"onSpecial_getPopulatedObjectPropertyList not implemented");
    }

    @Ignore
    @Test
    public void onOrdinary_getPopulatedObjectPropertyList() {
        Assert.fail((String)"onOrdinary_getPopulatedObjectPropertyList not implemented");
    }

    @Test
    public void hiddenFauxWithVisibleBase() {
        this.indOrdinary.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_VISIBLE, FAUX_DOMAIN_HIDDEN, FAUX_RANGE_HIDDEN), URI_FAUX_HIDDEN_ORDINARY);
        this.filteredOrdinary = new IndividualFiltering((Individual)this.indOrdinary, (VitroFilters)new IndividualBasedFilter());
        List<ObjectPropertyStatement> expected = this.opsList(this.filteredOrdinary, this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_ORDINARY));
        List actual = this.filteredOrdinary.getObjectPropertyStatements();
        this.assertEquivalentOpsList("hidden faux is not visible", expected, actual);
    }

    @Test
    public void visibleFauxWithHiddenBase() {
        this.indOrdinary.addObjectPropertyStatement(this.property(PROPERTY_OBJECT_HIDDEN, FAUX_DOMAIN_VISIBLE, FAUX_RANGE_VISIBLE), URI_FAUX_VISIBLE_ORDINARY);
        this.filteredOrdinary = new IndividualFiltering((Individual)this.indOrdinary, (VitroFilters)new IndividualBasedFilter());
        List<ObjectPropertyStatement> expected = this.opsList(this.filteredOrdinary, this.ops(PROPERTY_OBJECT_VISIBLE, URI_VISIBLE_OBJECT_ORDINARY), this.ops(PROPERTY_OBJECT_HIDDEN, URI_FAUX_VISIBLE_ORDINARY));
        List actual = this.filteredOrdinary.getObjectPropertyStatements();
        this.assertEquivalentOpsList("visible faux even if base is hidden", expected, actual);
    }

    private DataPropertyStatement dps(String propertyUri, String value) {
        return this.dps("", propertyUri, value);
    }

    private DataPropertyStatement dps(String subjectUri, String propertyUri, String value) {
        return new DPS(subjectUri, propertyUri, value);
    }

    private List<DataPropertyStatement> dpsList(Individual ind, DataPropertyStatement ... dpsArray) {
        ArrayList<DataPropertyStatement> list = new ArrayList<DataPropertyStatement>();
        for (DataPropertyStatement dps : dpsArray) {
            list.add(new DPS(ind.getURI(), dps.getDatapropURI(), dps.getData()));
        }
        return list;
    }

    private void assertEquivalentDpsList(String label, Collection<DataPropertyStatement> expected, Collection<DataPropertyStatement> actual) {
        HashSet<DPS> expectedSet = new HashSet<DPS>();
        for (DataPropertyStatement dps : expected) {
            expectedSet.add(new DPS(dps));
        }
        HashSet<DPS> actualSet = new HashSet<DPS>();
        for (DataPropertyStatement dps : actual) {
            actualSet.add(new DPS(dps));
        }
        Assert.assertEquals((String)label, expectedSet, actualSet);
    }

    private void assertEquivalentDps(String label, DataPropertyStatement expected, DataPropertyStatement actual) {
        DPS expectedDps = expected == null ? null : new DPS(expected);
        DPS actualDps = actual == null ? null : new DPS(actual);
        Assert.assertEquals((String)label, (Object)expectedDps, (Object)actualDps);
    }

    private ObjectPropertyStatement ops(String propertyUri, String objectUri) {
        return this.ops("", propertyUri, objectUri);
    }

    private ObjectPropertyStatement ops(String subjectUri, String propertyUri, String objectUri) {
        return new OPS(subjectUri, propertyUri, objectUri);
    }

    private List<ObjectPropertyStatement> opsList(Individual ind, ObjectPropertyStatement ... opsArray) {
        ArrayList<ObjectPropertyStatement> list = new ArrayList<ObjectPropertyStatement>();
        for (ObjectPropertyStatement ops : opsArray) {
            list.add(new OPS(ind.getURI(), ops.getPropertyURI(), ops.getObjectURI()));
        }
        return list;
    }

    private void assertEquivalentOpsList(String label, Collection<ObjectPropertyStatement> expected, Collection<ObjectPropertyStatement> actual) {
        HashSet<OPS> expectedSet = new HashSet<OPS>();
        for (ObjectPropertyStatement ops : expected) {
            expectedSet.add(new OPS(ops));
        }
        HashSet<OPS> actualSet = new HashSet<OPS>();
        for (ObjectPropertyStatement ops : actual) {
            actualSet.add(new OPS(ops));
        }
        Assert.assertEquals((String)label, expectedSet, actualSet);
    }

    private static class IndividualBasedFilter
    implements VitroFilters {
        private IndividualBasedFilter() {
        }

        public UnaryFunctor<DataPropertyStatement, Boolean> getDataPropertyStatementFilter() {
            return new DataPropertyStatementFilter();
        }

        public UnaryFunctor<ObjectPropertyStatement, Boolean> getObjectPropertyStatementFilter() {
            return new ObjectPropertyStatementFilter();
        }

        public VitroFilters and(VitroFilters other) {
            throw new RuntimeException("VitroFilters.and() not implemented.");
        }

        public UnaryFunctor<Individual, Boolean> getIndividualFilter() {
            throw new RuntimeException("VitroFilters.getIndividualFilter() not implemented.");
        }

        public UnaryFunctor<DataProperty, Boolean> getDataPropertyFilter() {
            throw new RuntimeException("VitroFilters.getDataPropertyFilter() not implemented.");
        }

        public UnaryFunctor<ObjectProperty, Boolean> getObjectPropertyFilter() {
            throw new RuntimeException("VitroFilters.getObjectPropertyFilter() not implemented.");
        }

        public UnaryFunctor<VClass, Boolean> getClassFilter() {
            throw new RuntimeException("VitroFilters.getClassFilter() not implemented.");
        }

        public UnaryFunctor<VClassGroup, Boolean> getVClassGroupFilter() {
            throw new RuntimeException("VitroFilters.getVClassGroupFilter() not implemented.");
        }

        public UnaryFunctor<PropertyGroup, Boolean> getPropertyGroupFilter() {
            throw new RuntimeException("VitroFilters.getPropertyGroupFilter() not implemented.");
        }

        private static class ObjectPropertyStatementFilter
        extends UnaryFunctor<ObjectPropertyStatement, Boolean> {
            private ObjectPropertyStatementFilter() {
            }

            public Boolean fn(ObjectPropertyStatement ops) {
                if (IndividualFilteringByStatementTest.PROPERTY_OBJECT_VISIBLE.equals(ops.getPropertyURI())) {
                    return !this.isFauxHidden(ops);
                }
                if (IndividualFilteringByStatementTest.PROPERTY_OBJECT_MAYBE.equals(ops.getPropertyURI()) && IndividualFilteringByStatementTest.URI_INDIVIDUAL_SPECIAL.equals(ops.getSubjectURI())) {
                    return true;
                }
                if (this.isFauxVisible(ops)) {
                    return true;
                }
                return false;
            }

            private boolean isFauxHidden(ObjectPropertyStatement ops) {
                ObjectProperty prop = ops.getProperty();
                return IndividualFilteringByStatementTest.FAUX_DOMAIN_HIDDEN.equals(prop.getDomainVClassURI()) && IndividualFilteringByStatementTest.FAUX_RANGE_HIDDEN.equals(prop.getRangeVClassURI());
            }

            private boolean isFauxVisible(ObjectPropertyStatement ops) {
                ObjectProperty prop = ops.getProperty();
                return IndividualFilteringByStatementTest.FAUX_DOMAIN_VISIBLE.equals(prop.getDomainVClassURI()) && IndividualFilteringByStatementTest.FAUX_RANGE_VISIBLE.equals(prop.getRangeVClassURI());
            }
        }

        private static class DataPropertyStatementFilter
        extends UnaryFunctor<DataPropertyStatement, Boolean> {
            private DataPropertyStatementFilter() {
            }

            public Boolean fn(DataPropertyStatement dps) {
                if (IndividualFilteringByStatementTest.PROPERTY_DATA_VISIBLE.equals(dps.getDatapropURI())) {
                    return true;
                }
                if (IndividualFilteringByStatementTest.PROPERTY_DATA_MAYBE.equals(dps.getDatapropURI()) && IndividualFilteringByStatementTest.URI_INDIVIDUAL_SPECIAL.equals(dps.getIndividualURI())) {
                    return true;
                }
                return false;
            }
        }
    }

    private static class OPS
    implements ObjectPropertyStatement {
        private final String subjectUri;
        private final String predicateUri;
        private final String objectUri;

        public OPS(String subjectUri, String predicateUri, String objectUri) {
            this.subjectUri = subjectUri;
            this.predicateUri = predicateUri;
            this.objectUri = objectUri;
        }

        public OPS(ObjectPropertyStatement ops) {
            this(ops.getSubjectURI(), ops.getPropertyURI(), ops.getObjectURI());
        }

        public String getSubjectURI() {
            return this.subjectUri;
        }

        public String getPropertyURI() {
            return this.predicateUri;
        }

        public String getObjectURI() {
            return this.objectUri;
        }

        public int hashCode() {
            return this.subjectUri.hashCode() ^ this.predicateUri.hashCode() ^ this.objectUri.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OPS)) {
                return false;
            }
            OPS that = (OPS)obj;
            return this.subjectUri.equals(that.subjectUri) && this.predicateUri.equals(that.predicateUri) && this.objectUri.equals(that.objectUri);
        }

        public String toString() {
            return "OPS[" + this.subjectUri + ", " + this.predicateUri + ", " + this.objectUri + "]";
        }

        public void setSubjectURI(String subjectURI) {
            throw new RuntimeException("ObjectPropertyStatement.setSubjectURI() not implemented.");
        }

        public void setObjectURI(String objectURI) {
            throw new RuntimeException("ObjectPropertyStatement.setObjectURI() not implemented.");
        }

        public Individual getSubject() {
            throw new RuntimeException("ObjectPropertyStatement.getSubject() not implemented.");
        }

        public void setSubject(Individual subject) {
            throw new RuntimeException("ObjectPropertyStatement.setSubject() not implemented.");
        }

        public ObjectProperty getProperty() {
            throw new RuntimeException("ObjectPropertyStatement.getProperty() not implemented.");
        }

        public void setProperty(ObjectProperty property) {
            throw new RuntimeException("ObjectPropertyStatement.setProperty() not implemented.");
        }

        public Individual getObject() {
            throw new RuntimeException("ObjectPropertyStatement.getObject() not implemented.");
        }

        public void setObject(Individual object) {
            throw new RuntimeException("ObjectPropertyStatement.setObject() not implemented.");
        }

        public void setPropertyURI(String URI2) {
            throw new RuntimeException("ObjectPropertyStatement.setPropertyURI() not implemented.");
        }

        public PropertyInstance toPropertyInstance() {
            throw new RuntimeException("ObjectPropertyStatement.toPropertyInstance() not implemented.");
        }
    }

    private static class DPS
    implements DataPropertyStatement {
        private final String subjectUri;
        private final String predicateUri;
        private final String value;

        public DPS(String subjectUri, String predicateUri, String value) {
            this.subjectUri = subjectUri;
            this.predicateUri = predicateUri;
            this.value = value;
        }

        public DPS(DataPropertyStatement dps) {
            this(dps.getIndividualURI(), dps.getDatapropURI(), dps.getData());
        }

        public String getIndividualURI() {
            return this.subjectUri;
        }

        public String getDatapropURI() {
            return this.predicateUri;
        }

        public String getData() {
            return this.value;
        }

        public int hashCode() {
            return this.subjectUri.hashCode() ^ this.predicateUri.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DPS)) {
                return false;
            }
            DPS that = (DPS)obj;
            return this.subjectUri.equals(that.subjectUri) && this.predicateUri.equals(that.predicateUri) && this.value.equals(that.value);
        }

        public String toString() {
            return "DPS[" + this.subjectUri + ", " + this.predicateUri + ", " + this.value + "]";
        }

        public Individual getIndividual() {
            throw new RuntimeException("DataPropertyStatement.getIndividual() not implemented.");
        }

        public void setIndividual(Individual individual) {
            throw new RuntimeException("DataPropertyStatement.setIndividual() not implemented.");
        }

        public void setIndividualURI(String individualURI) {
            throw new RuntimeException("DataPropertyStatement.setIndividualURI() not implemented.");
        }

        public void setData(String data) {
            throw new RuntimeException("DataPropertyStatement.setData() not implemented.");
        }

        public void setDatapropURI(String propertyURI) {
            throw new RuntimeException("DataPropertyStatement.setDatapropURI() not implemented.");
        }

        public String getDatatypeURI() {
            throw new RuntimeException("DataPropertyStatement.getDatatypeURI() not implemented.");
        }

        public void setDatatypeURI(String datatypeURI) {
            throw new RuntimeException("DataPropertyStatement.setDatatypeURI() not implemented.");
        }

        public String getLanguage() {
            throw new RuntimeException("DataPropertyStatement.getLanguage() not implemented.");
        }

        public void setLanguage(String language) {
            throw new RuntimeException("DataPropertyStatement.setLanguage() not implemented.");
        }

        public String getString() {
            throw new RuntimeException("DataPropertyStatement.getString() not implemented.");
        }
    }
}

