/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DataPropertyDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.OutputStream;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Test;

public class DataPropertyDaoJenaTest
extends AbstractTestClass {
    @Test
    public void minimalUpdates() {
        String propertyURI = "http://vivoweb.org/ontology/core#addressCity";
        OntModel superModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel subModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        superModel.addSubModel((Model)subModel);
        String rdfsLabel = "this is the rdfs label";
        String lang = "en-US";
        DatatypeProperty property1 = subModel.createDatatypeProperty(propertyURI);
        property1.setLabel(rdfsLabel, lang);
        property1.setPropertyValue(RDFS.domain, (RDFNode)subModel.createResource("http://thisIsTheDomainClassURI"));
        property1.setPropertyValue(RDFS.range, (RDFNode)subModel.createResource("http://thisIsTheRangeClassURI"));
        property1.addProperty(RDF.type, (RDFNode)OWL.FunctionalProperty);
        property1.setPropertyValue(subModel.createProperty("http://purl.obolibrary.org/obo/IAO_0000112"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the example", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#descriptionAnnot"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the description", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#publicDescriptionAnnot"), (RDFNode)ResourceFactory.createLangLiteral((String)"this is the public description", (String)lang));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayRankAnnot"), (RDFNode)subModel.createTypedLiteral(21));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#displayLimitAnnot"), (RDFNode)subModel.createTypedLiteral(5));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#inPropertyGroupAnnot"), (RDFNode)subModel.createResource("http://thisIsTheInPropertyGroupURI"));
        property1.setPropertyValue(subModel.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#customEntryFormAnnot"), (RDFNode)subModel.createResource("http://thisIsTheCustomFormEntryURI"));
        superModel.removeSubModel((Model)subModel);
        OntModel origSubModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSubModel.add((Model)subModel);
        OntModel origSuperModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        origSuperModel.add((Model)superModel);
        superModel.addSubModel((Model)subModel);
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(superModel);
        DataPropertyDaoJena dpdj = (DataPropertyDaoJena)wdfj.getDataPropertyDao();
        DataProperty dataProperty = dpdj.getDataPropertyByURI(propertyURI);
        Assert.assertEquals((Object)dataProperty.getPublicName(), (Object)property1.getLabel(lang));
        dpdj.updateDataProperty(dataProperty);
        superModel.removeSubModel((Model)subModel);
        this.wipeOutModTime((Model)origSubModel);
        this.wipeOutModTime((Model)origSuperModel);
        this.wipeOutModTime((Model)subModel);
        this.wipeOutModTime((Model)superModel);
        Assert.assertTrue((boolean)subModel.isIsomorphicWith((Model)origSubModel));
        Assert.assertTrue((boolean)superModel.isIsomorphicWith((Model)origSuperModel));
    }

    void printModels(OntModel superModel, OntModel subModel) {
        superModel.removeSubModel((Model)subModel);
        System.out.println("\nThe sub-model has " + subModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        subModel.writeAll((OutputStream)System.out, "N3", null);
        System.out.println("\nThe super-model has " + superModel.size() + " statements:");
        System.out.println("---------------------------------------------------");
        superModel.write((OutputStream)System.out, "N3", null);
        superModel.addSubModel((Model)subModel);
    }

    void wipeOutModTime(Model model) {
        model.removeAll(null, model.createProperty("http://vitro.mannlib.cornell.edu/ns/vitro/0.7#modTime"), null);
    }
}

