/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class RDFServiceGraphTest
extends AbstractTestClass {
    @Test
    public void testEventListening() throws RDFServiceException {
        Model m = ModelFactory.createDefaultModel();
        RDFServiceModel rdfService = new RDFServiceModel(m);
        EventsCounter counter = new EventsCounter();
        rdfService.registerListener((ChangeListener)counter);
        RDFServiceGraph g = new RDFServiceGraph((RDFService)rdfService);
        Model model = null;
        for (int i = 0; i < 100; ++i) {
            model = RDFServiceGraph.createRDFServiceModel((RDFServiceGraph)g);
        }
        model.notifyEvent((Object)"event");
        Assert.assertEquals((long)1L, (long)counter.getCount());
    }

    private class EventsCounter
    implements ChangeListener {
        private int count = 0;

        private EventsCounter() {
        }

        public int getCount() {
            return this.count;
        }

        public void notifyModelChange(ModelChange modelChange) {
        }

        public void notifyEvent(String graphURI, Object event) {
            ++this.count;
        }
    }
}

