/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditN3GeneratorVTwo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ResourceFactory;
import org.junit.Assert;
import org.junit.Test;

public class EditN3GeneratorVTwoTest {
    static EditN3GeneratorVTwo gen = new EditN3GeneratorVTwo();

    @Test
    public void testVarAtEndOfString() {
        String result = gen.subInNonBracketedURIS("newRes", "<http://someuri.com/n23", "?newRes");
        Assert.assertEquals((Object)"<http://someuri.com/n23", (Object)result);
    }

    @Test
    public void testNullTarget() {
        List<String> targets = Arrays.asList("?var", null, null, "?var");
        HashMap<String, List<String>> keyToValues = new HashMap<String, List<String>>();
        keyToValues.put("var", Arrays.asList("ABC"));
        keyToValues.put("var2", Arrays.asList(new String[]{null}));
        gen.subInMultiUris(null, targets);
        gen.subInMultiUris(keyToValues, null);
        gen.subInMultiUris(keyToValues, targets);
        HashMap<String, List<Literal>> keyToLiterals = new HashMap<String, List<Literal>>();
        keyToLiterals.put("var", Arrays.asList(ResourceFactory.createTypedLiteral((Object)"String")));
        keyToLiterals.put("var2", Arrays.asList(new Literal[]{null}));
        gen.subInMultiLiterals(keyToLiterals, targets);
        gen.subInMultiLiterals(keyToLiterals, null);
        gen.subInMultiLiterals(null, targets);
    }

    @Test
    public void testPunctAfterVarName() {
        List<String> targets = Arrays.asList("?var.", "?var;", "?var]", "?var,");
        HashMap<String, List<String>> keyToValues = new HashMap<String, List<String>>();
        keyToValues.put("var", Arrays.asList("ABC"));
        gen.subInMultiUris(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertEquals((Object)"<ABC>.", (Object)targets.get(0));
        Assert.assertEquals((Object)"<ABC>;", (Object)targets.get(1));
        Assert.assertEquals((Object)"<ABC>]", (Object)targets.get(2));
        Assert.assertEquals((Object)"<ABC>,", (Object)targets.get(3));
    }

    @Test
    public void testPunctAfterVarNameForLiterals() {
        List<String> targets = Arrays.asList("?var.", "?var;", "?var]", "?var,");
        HashMap<String, List<EditLiteral>> keyToValues = new HashMap<String, List<EditLiteral>>();
        keyToValues.put("var", Arrays.asList(new EditLiteral("ABC", null, null)));
        gen.subInMultiLiterals(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertEquals((Object)"\"ABC\".", (Object)targets.get(0));
        Assert.assertEquals((Object)"\"ABC\";", (Object)targets.get(1));
        Assert.assertEquals((Object)"\"ABC\"]", (Object)targets.get(2));
        Assert.assertEquals((Object)"\"ABC\",", (Object)targets.get(3));
    }

    @Test
    public void testLiterlasWithDatatypes() {
        List<String> targets = Arrays.asList("?var.", "?var;", "?var]", "?var,", "?var", " ?var ");
        String value = "ABC";
        String datatype = "http://someDataType.com/bleck";
        String expected = '\"' + value + '\"' + "^^<" + datatype + ">";
        HashMap<String, List<EditLiteral>> keyToValues = new HashMap<String, List<EditLiteral>>();
        keyToValues.put("var", Arrays.asList(new EditLiteral(value, datatype, null)));
        gen.subInMultiLiterals(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)6L, (long)targets.size());
        Assert.assertEquals((Object)(expected + "."), (Object)targets.get(0));
        Assert.assertEquals((Object)(expected + ";"), (Object)targets.get(1));
        Assert.assertEquals((Object)(expected + "]"), (Object)targets.get(2));
        Assert.assertEquals((Object)(expected + ","), (Object)targets.get(3));
        Assert.assertEquals((Object)expected, (Object)targets.get(4));
        Assert.assertEquals((Object)(" " + expected + " "), (Object)targets.get(5));
    }

    @Test
    public void testLiterlasWithLang() {
        List<String> targets = Arrays.asList("?var.", "?var;", "?var]", "?var,", "?var", " ?var ");
        String value = "ABC";
        String datatype = null;
        String lang = "XYZ";
        String expected = '\"' + value + '\"' + "@" + lang + "";
        HashMap<String, List<EditLiteral>> keyToValues = new HashMap<String, List<EditLiteral>>();
        keyToValues.put("var", Arrays.asList(new EditLiteral(value, datatype, lang)));
        gen.subInMultiLiterals(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)6L, (long)targets.size());
        Assert.assertEquals((Object)(expected + "."), (Object)targets.get(0));
        Assert.assertEquals((Object)(expected + ";"), (Object)targets.get(1));
        Assert.assertEquals((Object)(expected + "]"), (Object)targets.get(2));
        Assert.assertEquals((Object)(expected + ","), (Object)targets.get(3));
        Assert.assertEquals((Object)expected, (Object)targets.get(4));
        Assert.assertEquals((Object)(" " + expected + " "), (Object)targets.get(5));
    }

    @Test
    public void testSubInMultiUrisNull() {
        String n3 = "?varXYZ";
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(n3);
        HashMap keyToValues = new HashMap();
        ArrayList<Object> targetValue = new ArrayList<Object>();
        targetValue.add(null);
        keyToValues.put("varXYZ", targetValue);
        gen.subInMultiUris(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)1L, (long)targets.size());
        String resultN3 = (String)targets.get(0);
        Assert.assertNotNull((Object)resultN3);
        Assert.assertTrue((String)"String was empty", (!resultN3.isEmpty() ? 1 : 0) != 0);
        String not_expected = "<null>";
        Assert.assertTrue((String)"must not sub in <null>", (!not_expected.equals(resultN3) ? 1 : 0) != 0);
        not_expected = "<>";
        Assert.assertTrue((String)"must not sub in <>", (!not_expected.equals(resultN3) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"?varXYZ", (Object)resultN3);
    }

    @Test
    public void testSubInMultiUrisEmptyString() {
        String n3 = "?varXYZ";
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(n3);
        HashMap keyToValues = new HashMap();
        ArrayList<String> targetValue = new ArrayList<String>();
        targetValue.add("");
        keyToValues.put("varXYZ", targetValue);
        gen.subInMultiUris(keyToValues, targets);
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)1L, (long)targets.size());
        String resultN3 = (String)targets.get(0);
        Assert.assertNotNull((Object)resultN3);
        Assert.assertTrue((String)"String was empty", (!resultN3.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"?varXYZ", (Object)resultN3);
    }

    @Test
    public void testSubInUrisNull() {
        String n3 = " ?varXYZ ";
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(n3);
        HashMap<String, String> keyToValues = new HashMap<String, String>();
        keyToValues.put("varXYZ", "xyzURI");
        gen.subInUris(keyToValues, targets);
        ArrayList<String> result = targets;
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        String resultN3 = (String)result.get(0);
        Assert.assertNotNull((Object)resultN3);
        Assert.assertTrue((String)"String was empty", (!resultN3.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)" <xyzURI> ", (Object)resultN3);
        keyToValues = new HashMap();
        keyToValues.put("varXYZ", null);
        ArrayList<String> targets2 = new ArrayList<String>();
        targets2.add(n3);
        gen.subInUris(keyToValues, targets2);
        Assert.assertNotNull(targets2);
        Assert.assertEquals((long)1L, (long)targets2.size());
        resultN3 = (String)targets2.get(0);
        Assert.assertNotNull((Object)resultN3);
        Assert.assertTrue((String)"String was empty", (!resultN3.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((Object)" ?varXYZ ", (Object)resultN3);
    }

    @Test
    public void testSubInMultiUris() {
        String n3 = "?subject ?predicate ?multivalue .";
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(n3);
        HashMap keyToValues = new HashMap();
        ArrayList<String> values = new ArrayList<String>();
        values.add("http://a.com/2");
        values.add("http://b.com/ont#2");
        values.add("http://c.com/individual/n23431");
        keyToValues.put("multivalue", values);
        ArrayList<String> subject = new ArrayList<String>();
        ArrayList<String> predicate = new ArrayList<String>();
        subject.add("http://testsubject.com/1");
        predicate.add("http://testpredicate.com/2");
        keyToValues.put("subject", subject);
        keyToValues.put("predicate", predicate);
        gen.subInMultiUris(keyToValues, strs);
        Assert.assertNotNull(strs);
        Assert.assertTrue((strs.size() == 1 ? 1 : 0) != 0);
        String expected = "<http://testsubject.com/1> <http://testpredicate.com/2> <http://a.com/2>, <http://b.com/ont#2>, <http://c.com/individual/n23431> .";
        Assert.assertEquals((Object)expected, strs.get(0));
        Model expectedModel = ModelFactory.createDefaultModel();
        StringReader expectedReader = new StringReader(expected);
        StringReader resultReader = new StringReader((String)strs.get(0));
        expectedModel.read((Reader)expectedReader, null, "N3");
        Model resultModel = ModelFactory.createDefaultModel();
        resultModel.read((Reader)resultReader, null, "N3");
        Assert.assertTrue((boolean)expectedModel.isIsomorphicWith(resultModel));
    }
}

