/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.i18n.TranslationConverter;
import edu.cornell.mannlib.vitro.webapp.i18n.VitroResourceBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;

public class TranslationConverterTest {
    private static final String WILMA = "wilma";
    private static final String HAS_THEME = "http://vivoweb.org/ontology/vitro/ui-label/vocabulary#hasTheme";
    private static final String VITRO = "Vitro";
    private static final String VIVO = "VIVO";
    private static final String HAS_APP = "http://vivoweb.org/ontology/vitro/ui-label/vocabulary#hasApp";
    private static final String HAS_KEY = "http://vivoweb.org/ontology/vitro/ui-label/vocabulary#hasKey";
    private static final String ROOT_PATH = "src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationConverterTest/root";
    private static final String INIT_N3_FILE = "src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationConverterTest/modelInitContent.n3";
    ServletContextStub ctx = new ServletContextStub();
    private OntModel model;

    @Before
    public void init() {
        Logger logger = LogManager.getLogger(TranslationConverter.class);
        logger.setLevel(Level.ERROR);
    }

    @After
    public void finish() {
        Logger logger = LogManager.getLogger(TranslationConverter.class);
        logger.setLevel(Level.INFO);
    }

    @Test
    public void testConversion() throws FileNotFoundException {
        VitroResourceBundle.addAppPrefix((String)"customprefix");
        VitroResourceBundle.addAppPrefix((String)"vivo");
        TranslationConverter converter = TranslationConverter.getInstance();
        this.model = converter.memModel;
        File n3 = new File(INIT_N3_FILE);
        Assert.assertTrue((boolean)this.model.isEmpty());
        this.model.read((Reader)new FileReader(n3), null, "n3");
        Assert.assertFalse((boolean)this.model.isEmpty());
        File appI18n = new File("src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationConverterTest/root/i18n/");
        File localI18n = new File("src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationConverterTest/root/local/i18n/");
        File themes = new File("src/test/resources/edu/cornell/mannlib/vitro/webapp/i18n/TranslationConverterTest/root/themes/");
        this.ctx.setRealPath("/i18n/", appI18n.getAbsolutePath());
        this.ctx.setRealPath("/local/i18n/", localI18n.getAbsolutePath());
        this.ctx.setRealPath("/themes/", themes.getAbsolutePath());
        converter.ctx = this.ctx;
        converter.convertAll();
        Assert.assertEquals((long)2L, (long)this.getCount(HAS_KEY, "test_key_all_en_US"));
        Assert.assertEquals((long)2L, (long)this.getCount(HAS_KEY, "test_key_all_en_CA"));
        Assert.assertEquals((long)2L, (long)this.getCount(HAS_KEY, "test_key_all"));
        Assert.assertEquals((long)1L, (long)this.getCount(HAS_KEY, "property_to_overwrite"));
        Assert.assertTrue((boolean)this.n3TranslationValueIsOverwrittenByProperty(this.model));
        Assert.assertEquals((long)3L, (long)this.getCount(HAS_THEME, WILMA));
        Assert.assertEquals((long)6L, (long)this.getCount(HAS_APP, VITRO));
        Assert.assertEquals((long)3L, (long)this.getCount(HAS_APP, VIVO));
    }

    private void printResultModel() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.model.write((OutputStream)baos, "N3");
        System.out.println(baos.toString());
    }

    private int getCount(String hasTheme, String wilma) {
        SimpleSelector selector = new SimpleSelector(null, (Property)new PropertyImpl(hasTheme), wilma);
        StmtIterator it = this.model.listStatements((Selector)selector);
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    private boolean n3TranslationValueIsOverwrittenByProperty(OntModel model) {
        return model.getGraph().contains(NodeFactory.createURI((String)"urn:uuid:8c80dbf5-adda-41d5-a6fe-d5efde663600"), NodeFactory.createURI((String)"http://www.w3.org/2000/01/rdf-schema#label"), NodeFactory.createLiteral((String)"value from properties file", (String)"en-US"));
    }
}

