/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.LocaleSelectionSetup;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.edu.cornell.mannlib.vitro.webapp.startup.StartupStatusStub;
import stubs.javax.servlet.ServletContextStub;

public class LocaleSelectionSetupTest
extends AbstractTestClass {
    private LocaleSelectionSetup lss;
    private ServletContextStub ctx;
    private ServletContextEvent sce;
    private ConfigurationPropertiesStub props;
    private StartupStatusStub ss;
    private int[] expectedMessageCounts;
    private Locale expectedForcedLocale;
    private List<Locale> expectedSelectableLocales;

    @Before
    public void setup() {
        LocaleSelectionSetupTest.setLoggerLevel(ConfigurationProperties.class, Level.WARN);
        this.ctx = new ServletContextStub();
        this.sce = new ServletContextEvent((ServletContext)this.ctx);
        this.props = new ConfigurationPropertiesStub();
        this.props.setBean(this.ctx);
        this.ss = new StartupStatusStub(this.ctx);
        this.lss = new LocaleSelectionSetup();
    }

    @After
    public void checkExpectations() {
        String message;
        if (this.expectedMessageCounts == null) {
            Assert.fail((String)"expectedMessages() was not called");
        }
        if (!(message = this.compareMessageCount("info", this.ss.getInfoCount(), this.expectedMessageCounts[0]) + this.compareMessageCount("warning", this.ss.getWarningCount(), this.expectedMessageCounts[1]) + this.compareMessageCount("fatal", this.ss.getFatalCount(), this.expectedMessageCounts[2]) + this.checkForced() + this.checkSelectable()).isEmpty()) {
            Assert.fail((String)message);
        }
    }

    private String compareMessageCount(String label, int actual, int expected) {
        if (expected == actual) {
            return "";
        }
        return "expecting " + expected + " " + label + " messages, but received " + actual + "; ";
    }

    private String checkForced() {
        Locale expected;
        Locale actual = null;
        Object o = this.ctx.getAttribute("SELECTED_LOCALE");
        if (o instanceof SelectedLocale.ContextSelectedLocale) {
            actual = ((SelectedLocale.ContextSelectedLocale)o).getForcedLocale();
        }
        if (ObjectUtils.equals((Object)(expected = this.expectedForcedLocale), (Object)actual)) {
            return "";
        }
        return "expected forced locale of " + this.expectedForcedLocale + ", but was " + actual + "; ";
    }

    private String checkSelectable() {
        List<Locale> expected;
        List actual = Collections.emptyList();
        Object o = this.ctx.getAttribute("SELECTED_LOCALE");
        if (o instanceof SelectedLocale.ContextSelectedLocale) {
            actual = ((SelectedLocale.ContextSelectedLocale)o).getSelectableLocales();
        }
        if ((expected = this.expectedSelectableLocales) == null) {
            expected = Collections.emptyList();
        }
        if (ObjectUtils.equals(expected, (Object)actual)) {
            return "";
        }
        return "expected selectable locales of " + expected + ", but was " + actual + "; ";
    }

    @Test
    public void neitherPropertyIsSpecified() {
        this.lss.contextInitialized(this.sce);
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void forceSuccessL() {
        this.props.setProperty("languages.forceLocale", "es");
        this.lss.contextInitialized(this.sce);
        this.expectForced("es");
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void forceSuccessL_C() {
        this.props.setProperty("languages.forceLocale", "es_ES");
        this.lss.contextInitialized(this.sce);
        this.expectForced("es_ES");
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void forceSuccessL_C_V() {
        this.props.setProperty("languages.forceLocale", "no_NO_NY");
        this.lss.contextInitialized(this.sce);
        this.expectForced("no_NO_NY");
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void oneSelectable() {
        this.props.setProperty("languages.selectableLocales", "fr_FR");
        this.lss.contextInitialized(this.sce);
        this.expectSelectable("fr_FR");
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void twoSelectables() {
        this.props.setProperty("languages.selectableLocales", "fr_FR, es_PE");
        this.lss.contextInitialized(this.sce);
        this.expectSelectable("fr_FR", "es_PE");
        this.expectMessages(1, 0, 0);
    }

    @Test
    public void bothPropertiesAreSpecified() {
        this.props.setProperty("languages.forceLocale", "es_ES");
        this.props.setProperty("languages.selectableLocales", "fr_FR");
        this.lss.contextInitialized(this.sce);
        this.expectForced("es_ES");
        this.expectMessages(1, 1, 0);
    }

    @Test
    public void langaugeIsEmpty() {
        this.props.setProperty("languages.forceLocale", "_ES");
        this.lss.contextInitialized(this.sce);
        this.expectForced("_ES");
        this.expectMessages(1, 1, 0);
    }

    @Test
    public void languageWrongLength() {
        this.props.setProperty("languages.forceLocale", "e_ES");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void languageNotAlphabetic() {
        this.props.setProperty("languages.forceLocale", "e4_ES");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void languageNotLowerCase() {
        this.props.setProperty("languages.forceLocale", "eS_ES");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void countryIsEmpty() {
        this.props.setProperty("languages.forceLocale", "es_ _13");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void countryWrongLength() {
        this.props.setProperty("languages.forceLocale", "es_ESS");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void countryNotAlphabetic() {
        this.props.setProperty("languages.forceLocale", "es_E@");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void countryNotUpperCase() {
        this.props.setProperty("languages.forceLocale", "es_es");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void variantIsEmpty() {
        this.props.setProperty("languages.forceLocale", "es_ES_");
        this.lss.contextInitialized(this.sce);
        this.expectMessages(0, 1, 0);
    }

    @Test
    public void localeNotRecognizedProducesWarning() {
        this.props.setProperty("languages.forceLocale", "es_FR");
        this.lss.contextInitialized(this.sce);
        this.expectForced("es_FR");
        this.expectMessages(1, 1, 0);
    }

    @Test
    public void emptySelectableLocaleProducesWarning() {
        this.props.setProperty("languages.selectableLocales", "es_ES, , fr_FR");
        this.lss.contextInitialized(this.sce);
        this.expectSelectable("es_ES", "fr_FR");
        this.expectMessages(1, 1, 0);
    }

    @Test
    public void blanksAroundCommasAreIgnored() {
        this.props.setProperty("languages.selectableLocales", "es_ES,en_US   \t ,      fr_FR");
        this.lss.contextInitialized(this.sce);
        this.expectSelectable("es_ES", "en_US", "fr_FR");
        this.expectMessages(1, 0, 0);
    }

    private void expectMessages(int infoCount, int warningCount, int fatalCount) {
        this.expectedMessageCounts = new int[]{infoCount, warningCount, fatalCount};
    }

    private void expectForced(String localeString) {
        this.expectedForcedLocale = this.stringToLocale(localeString);
    }

    private void expectSelectable(String ... strings) {
        ArrayList<Locale> list = new ArrayList<Locale>();
        for (String string : strings) {
            list.add(this.stringToLocale(string));
        }
        this.expectedSelectableLocales = list;
    }

    private Locale stringToLocale(String string) {
        return LocaleUtils.toLocale((String)string);
    }
}

