/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.migration.auth.AnnotationMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigratorTest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationMigratorTest
extends AuthMigratorTest {
    @Test
    public void testGetAnnotationConfigs() {
        AnnotationMigrator annotationMigrator = new AnnotationMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet));
        Map configs = annotationMigrator.getObjectPropertyAnnotations();
        Set ops = configs.keySet();
        Assert.assertEquals((long)1L, (long)configs.size());
        configs = annotationMigrator.getDataPropertyAnnotations();
        Set dps = configs.keySet();
        Assert.assertEquals((long)1L, (long)configs.size());
        configs = annotationMigrator.getClassAnnotations();
        Assert.assertEquals((long)2L, (long)configs.size());
        configs = annotationMigrator.getFauxObjectPropertyAnnotations(ops);
        Assert.assertEquals((long)1L, (long)configs.size());
        configs = annotationMigrator.getFauxDataPropertyAnnotations(dps);
        Assert.assertEquals((long)1L, (long)configs.size());
    }

    @Test
    public void testConvertAnnotationConfiguration() {
        AnnotationMigrator annotationMigrator = new AnnotationMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet));
        Model tmpModel = ModelFactory.createDefaultModel();
        tmpModel.add(this.configurationDataSet.getNamedModel("http://vitro.mannlib.cornell.edu/default/access-control"));
        long initialSize = this.accessControlModel.size();
        annotationMigrator.migrateConfiguration();
        Assert.assertTrue((this.configurationDataSet.getNamedModel("http://vitro.mannlib.cornell.edu/default/access-control").size() > initialSize ? 1 : 0) != 0);
        Model diff = this.configurationDataSet.getNamedModel("http://vitro.mannlib.cornell.edu/default/access-control").difference(tmpModel);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            diff.write((OutputStream)baos, "TTL");
            String newData = baos.toString();
            Assert.assertFalse((boolean)StringUtils.isBlank((CharSequence)newData));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testConfigurationVersion() {
        Model tmpModel = ModelFactory.createDefaultModel();
        tmpModel.add(this.configurationDataSet.getNamedModel("http://vitro.mannlib.cornell.edu/default/access-control"));
        Assert.assertEquals((long)0L, (long)this.migrator.getVersion());
        this.migrator.setVersion(1L);
        Assert.assertEquals((long)1L, (long)this.migrator.getVersion());
        this.migrator.removeVersion(1L);
        this.migrator.setVersion(2L);
        Assert.assertEquals((long)2L, (long)this.migrator.getVersion());
    }
}

