/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.migration.auth.ArmMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigratorTest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArmMigratorTest
extends AuthMigratorTest {
    private static final String FAUX_DATA_PROPERTY_URI = "http://vitro.mannlib.cornell.edu/ns/vitro/siteConfig/fp396";
    private static final String FAUX_OBJECT_PROPERTY_URI = "http://vitro.mannlib.cornell.edu/ns/vitro/siteConfig/orgAdministersGrantConfig";
    private static final String DATA_PROPERTY_URI = "http://vivoweb.org/ontology/core#abbreviation";
    private static final String CLASS_URI = "http://xmlns.com/foaf/0.1/Organization";
    private static final String OBJECT_PROPERTY_URI = "http://purl.obolibrary.org/obo/RO_0000053";
    private OntModel userAccountsModel;
    private ArmMigrator armMigrator;
    private String propertyUri = "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#forEntity";
    private String value = "https://vivoweb.org/ontology/vitro-application/auth/vocabulary/value";

    @Before
    public void initArmMigration() {
        this.userAccountsModel = ModelFactory.createOntologyModel();
        this.configurationDataSet.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", (Model)this.userAccountsModel);
    }

    @Test
    public void isArmConfigurationTest() {
        this.armMigrator = new ArmMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet), this.userAccountsModel);
        Assert.assertFalse((boolean)this.armMigrator.isArmConfiguation());
        this.addArmStatement("ADMIN", ArmMigrator.DISPLAY, OBJECT_PROPERTY_URI);
        Assert.assertTrue((boolean)this.armMigrator.isArmConfiguation());
    }

    private void addArmStatement(String role, String operation, String uri) {
        String persmissionUri = ArmMigrator.getArmPermissionSubject((String)operation, (String)role);
        String objectUri = uri;
        this.addUserAccountsStatement(persmissionUri, objectUri, this.propertyUri);
    }

    private void addUserAccountsStatement(String subjUri, String objUri, String pUri) {
        StatementImpl statement = new StatementImpl((Resource)new ResourceImpl(subjUri), (Property)new PropertyImpl(pUri), (RDFNode)new ResourceImpl(objUri));
        this.userAccountsModel.add((Statement)statement);
        this.configurationDataSet.replaceNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", (Model)this.userAccountsModel);
    }

    @Test
    public void getEntityMapTest() {
        this.armMigrator = new ArmMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet), this.userAccountsModel);
        Map map = this.armMigrator.getEntityMap();
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertEquals((long)1L, (long)((Set)map.get(AccessObjectType.OBJECT_PROPERTY)).size());
        Assert.assertEquals((long)1L, (long)((Set)map.get(AccessObjectType.DATA_PROPERTY)).size());
        Assert.assertEquals((long)2L, (long)((Set)map.get(AccessObjectType.CLASS)).size());
        Assert.assertEquals((long)1L, (long)((Set)map.get(AccessObjectType.FAUX_DATA_PROPERTY)).size());
        Assert.assertEquals((long)1L, (long)((Set)map.get(AccessObjectType.FAUX_DATA_PROPERTY)).size());
    }

    @Test
    public void getStatementsToRemoveTest() {
        this.armMigrator = new ArmMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet), this.userAccountsModel);
        StringBuilder removals = this.armMigrator.getStatementsToRemove();
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)removals.toString()));
        EntityPolicyController.updateEntityDataSet((String)"test:entity", (AccessObjectType)AccessObjectType.CLASS, (AccessOperation)AccessOperation.DISPLAY, (List)ROLE_LIST, (List)ROLE_LIST);
        removals = this.armMigrator.getStatementsToRemove();
        Assert.assertEquals((long)5L, (long)ArmMigratorTest.getCount("\n", removals.toString()));
    }

    @Test
    public void migrateConfigurationTest() {
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PermissionSet", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.armMigrator = new ArmMigrator((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet), this.userAccountsModel);
        this.addArmStatement("ADMIN", ArmMigrator.DISPLAY, OBJECT_PROPERTY_URI);
        this.addArmStatement("EDITOR", ArmMigrator.PUBLISH, OBJECT_PROPERTY_URI);
        this.addArmStatement("CURATOR", ArmMigrator.UPDATE, OBJECT_PROPERTY_URI);
        this.addArmStatement("SELF_EDITOR", ArmMigrator.DISPLAY, CLASS_URI);
        this.addArmStatement("EDITOR", ArmMigrator.PUBLISH, CLASS_URI);
        this.addArmStatement("ADMIN", ArmMigrator.DISPLAY, DATA_PROPERTY_URI);
        this.addArmStatement("EDITOR", ArmMigrator.PUBLISH, DATA_PROPERTY_URI);
        this.addArmStatement("CURATOR", ArmMigrator.UPDATE, DATA_PROPERTY_URI);
        this.addArmStatement("SELF_EDITOR", ArmMigrator.DISPLAY, FAUX_DATA_PROPERTY_URI);
        this.addArmStatement("EDITOR", ArmMigrator.PUBLISH, FAUX_DATA_PROPERTY_URI);
        this.addArmStatement("ADMIN", ArmMigrator.UPDATE, FAUX_DATA_PROPERTY_URI);
        this.addArmStatement("PUBLIC", ArmMigrator.DISPLAY, FAUX_OBJECT_PROPERTY_URI);
        this.addArmStatement("EDITOR", ArmMigrator.PUBLISH, FAUX_OBJECT_PROPERTY_URI);
        this.addArmStatement("CURATOR", ArmMigrator.UPDATE, FAUX_OBJECT_PROPERTY_URI);
        this.addArmStatement("CUSTOM", ArmMigrator.DISPLAY, OBJECT_PROPERTY_URI);
        this.addArmStatement("CUSTOM", ArmMigrator.UPDATE, FAUX_DATA_PROPERTY_URI);
        this.addArmStatement("CUSTOM", ArmMigrator.DISPLAY, CLASS_URI);
        Map entityTypeMap = this.armMigrator.getEntityMap();
        this.armMigrator.collectAdditions(entityTypeMap);
        String stringResult = this.armMigrator.additions.toString();
        Assert.assertFalse((boolean)stringResult.isEmpty());
        Assert.assertEquals((long)59L, (long)ArmMigratorTest.getCount("\n", stringResult));
        Assert.assertEquals((long)59L, (long)ArmMigratorTest.getCount(this.value, stringResult));
        Assert.assertEquals((long)26L, (long)ArmMigratorTest.getCount("http://www.w3.org/2000/01/rdf-schema#label", stringResult));
        Assert.assertEquals((long)6L, (long)ArmMigratorTest.getCount(OBJECT_PROPERTY_URI, stringResult));
        Assert.assertEquals((long)3L, (long)ArmMigratorTest.getCount(CLASS_URI, stringResult));
        Assert.assertEquals((long)5L, (long)ArmMigratorTest.getCount(DATA_PROPERTY_URI, stringResult));
        Assert.assertEquals((long)12L, (long)ArmMigratorTest.getCount(FAUX_DATA_PROPERTY_URI, stringResult));
        Assert.assertEquals((long)7L, (long)ArmMigratorTest.getCount(FAUX_OBJECT_PROPERTY_URI, stringResult));
    }

    private static long getCount(String pattern, String lines) {
        Matcher matcher = Pattern.compile(pattern).matcher(lines);
        long i = 0L;
        while (matcher.find()) {
            ++i;
        }
        return i;
    }
}

