/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSetRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTest;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AnnotationMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.ArmMigrator;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigrator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Before;

public class AuthMigratorTest
extends PolicyTest {
    protected static final String TEST_MIGRATION_RESOURCES_PREFIX = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/migration/";
    protected static final String CONTENT = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/migration/content.n3";
    protected static final String CONFIGURATION = "src/test/resources/edu/cornell/mannlib/vitro/webapp/auth/migration/configuration.n3";
    protected Model contentModel;
    protected Model configurationModel;
    protected AuthMigrator migrator;

    @Before
    public void initAuthMigration() {
        this.contentModel = ModelFactory.createDefaultModel();
        this.configurationModel = ModelFactory.createDefaultModel();
        this.migrator = new AuthMigrator();
        this.configurationDataSet.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", this.configurationModel);
        this.migrator.initialize((RDFService)new RDFServiceModel(this.contentModel), (RDFService)new RDFServiceModel(this.configurationDataSet));
        this.loadAllEntityPolicies();
        this.load(this.configurationModel, CONFIGURATION);
        this.configurationDataSet.replaceNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata", this.configurationModel);
        this.load(this.contentModel, CONTENT);
        AttributeValueSetRegistry.getInstance().clear();
        LogManager.getLogger(AnnotationMigrator.class).setLevel(Level.ERROR);
        LogManager.getLogger(ArmMigrator.class).setLevel(Level.ERROR);
    }

    @Override
    @After
    public void finish() {
        LogManager.getLogger(AnnotationMigrator.class).setLevel(Level.INFO);
        LogManager.getLogger(ArmMigrator.class).setLevel(Level.INFO);
    }
}

