/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.migration.auth;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyLoader;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyTemplateController;
import edu.cornell.mannlib.vitro.webapp.migration.auth.AuthMigratorTest;
import edu.cornell.mannlib.vitro.webapp.migration.auth.SimplePermissionMigrator;
import java.util.Set;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimplePermissionMigratorTest
extends AuthMigratorTest {
    private OntModel userAccountsModel;
    private SimplePermissionMigrator spm;
    private static final String TEMPLATE_PATH = "template_simple_permissions";
    public static final String ADMIN_SIMPLE_PERMISSIONS_PATH = "simple_permissions_admin";
    public static final String CURATOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_curator";
    public static final String EDITOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_editor";
    public static final String SELF_EDITOR_SIMPLE_PERMISSIONS_PATH = "simple_permissions_self_editor";
    public static final String PUBLIC_SIMPLE_PERMISSIONS_PATH = "simple_permissions_public";

    @Before
    public void initMigration() {
        this.userAccountsModel = ModelFactory.createOntologyModel();
        this.configurationDataSet.addNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", (Model)this.userAccountsModel);
        this.spm = new SimplePermissionMigrator(this.userAccountsModel);
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/template_simple_permissions.n3");
        Logger logger = LogManager.getLogger(SimplePermissionMigrator.class);
        logger.setLevel(Level.ERROR);
    }

    private void addUserAccountsStatement(String subjUri, String pUri, String objUri) {
        StatementImpl statement = new StatementImpl((Resource)new ResourceImpl(subjUri), (Property)new PropertyImpl(pUri), (RDFNode)new ResourceImpl(objUri));
        this.userAccountsModel.add((Statement)statement);
    }

    @Test
    public void getPermissionSetsTest() {
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        Set sets = this.spm.getPermissionSets();
        Assert.assertEquals((long)6L, (long)sets.size());
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM"));
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN"));
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR"));
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR"));
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR"));
        Assert.assertTrue((boolean)sets.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC"));
    }

    @Test
    public void getUserAccountPermissionsTest() {
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PermissionSet");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#hasPermission", SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri());
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#hasPermission", SimplePermission.DO_BACK_END_EDITING.getUri());
        Set permissions = this.spm.getUserAccountPermissions("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        Assert.assertEquals((long)2L, (long)permissions.size());
        Assert.assertTrue((boolean)permissions.contains(SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri()));
        Assert.assertTrue((boolean)permissions.contains(SimplePermission.DO_BACK_END_EDITING.getUri()));
        permissions = this.spm.getUserAccountPermissions("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        Assert.assertEquals((long)0L, (long)permissions.size());
    }

    @Test
    public void migrateConfigurationTest() {
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CURATOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#EDITOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        this.addPermissionSet("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#hasPermission", SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri());
        this.addUserAccountsStatement("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#hasPermission", SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri());
        this.load("../home/src/main/resources/rdf/accessControl/firsttime/simple_permissions_public.n3");
        PolicyTemplateController.createRoleDataSets((String)"http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        this.spm.migrateConfiguration();
        PolicyLoader policyLoader = PolicyLoader.getInstance();
        Set entities = policyLoader.getDataSetValues(AccessOperation.EXECUTE, AccessObjectType.NAMED_OBJECT, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#CUSTOM");
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)entities.contains(SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri()));
        entities = policyLoader.getDataSetValues(AccessOperation.EXECUTE, AccessObjectType.NAMED_OBJECT, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)entities.contains(SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri()));
        entities = policyLoader.getDataSetValues(AccessOperation.EXECUTE, AccessObjectType.NAMED_OBJECT, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
        Assert.assertEquals((long)1L, (long)entities.size());
        Assert.assertTrue((boolean)entities.contains(SimplePermission.ACCESS_SPECIAL_DATA_MODELS.getUri()));
    }

    private void addPermissionSet(String role) {
        this.addUserAccountsStatement(role, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PermissionSet");
    }
}

