/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice;

import edu.cornell.mannlib.vitro.webapp.dao.jena.event.BulkUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RDFServiceNotificationTest {
    private String TEST_TRIPLE = "<test:uri1> <test:pred1> \"test value\" .";
    private List<ModelChange> modelChanges = null;

    @Before
    public void reset() {
        this.modelChanges = new ArrayList<ModelChange>();
    }

    @Test
    public void testModelChangeUserIdNotificationAdd() throws RDFServiceException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        RDFServiceModel rdfServiceModel = new RDFServiceModel((Model)model);
        String editorUri = "test:user-id";
        rdfServiceModel.registerListener((ChangeListener)new TestListener());
        ChangeSet cs = this.createChangeSet(rdfServiceModel, editorUri, this.TEST_TRIPLE, null);
        rdfServiceModel.changeSetUpdate(cs);
        Assert.assertTrue((this.modelChanges.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)editorUri.equals(this.modelChanges.get(0).getUserId()));
    }

    @Test
    public void testModelChangeUserIdNotificationRetract() throws RDFServiceException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        RDFServiceModel rdfServiceModel = new RDFServiceModel((Model)model);
        String editorUri = "test:user-id";
        rdfServiceModel.registerListener((ChangeListener)new TestListener());
        ChangeSet cs = this.createChangeSet(rdfServiceModel, editorUri, null, this.TEST_TRIPLE);
        rdfServiceModel.changeSetUpdate(cs);
        Assert.assertTrue((this.modelChanges.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)editorUri.equals(this.modelChanges.get(0).getUserId()));
    }

    @Test
    public void testMultipleNotifications() throws RDFServiceException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        RDFServiceModel rdfServiceModel = new RDFServiceModel((Model)model);
        String editorUri = "test:user-id";
        int n = 5;
        for (int i = 0; i < n; ++i) {
            rdfServiceModel.registerListener((ChangeListener)new TestListener());
        }
        ChangeSet cs = this.createChangeSet(rdfServiceModel, editorUri, null, this.TEST_TRIPLE);
        rdfServiceModel.changeSetUpdate(cs);
        Assert.assertTrue((this.modelChanges.size() == n ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleNotificationsReceived() throws RDFServiceException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        RDFServiceModel rdfServiceModel = new RDFServiceModel((Model)model);
        String editorUri = "test:user-id";
        int n = 5;
        for (int i = 0; i < n; ++i) {
            rdfServiceModel.registerListener((ChangeListener)new TestListener(this.TEST_TRIPLE));
        }
        ChangeSet cs = this.createChangeSet(rdfServiceModel, editorUri, null, this.TEST_TRIPLE);
        rdfServiceModel.changeSetUpdate(cs);
    }

    private ChangeSet createChangeSet(RDFServiceModel rdfServiceModel, String editorUri, String additions, String retractions) {
        ChangeSet cs = rdfServiceModel.manufactureChangeSet();
        cs.addPreChangeEvent((Object)new BulkUpdateEvent(null, true));
        cs.addPostChangeEvent((Object)new BulkUpdateEvent(null, false));
        if (additions != null) {
            ByteArrayInputStream additionsInputStream = new ByteArrayInputStream(additions.getBytes(StandardCharsets.UTF_8));
            cs.addAddition((InputStream)additionsInputStream, RDFServiceUtils.getSerializationFormatFromJenaString((String)"N3"), null, editorUri);
        }
        if (retractions != null) {
            ByteArrayInputStream retractionsInputStream = new ByteArrayInputStream(retractions.getBytes(StandardCharsets.UTF_8));
            cs.addRemoval((InputStream)retractionsInputStream, RDFServiceUtils.getSerializationFormatFromJenaString((String)"N3"), null, editorUri);
        }
        return cs;
    }

    private class TestListener
    extends StatementListener
    implements ModelChangedListener,
    ChangeListener {
        private String serializedChange;

        public TestListener() {
        }

        public TestListener(String serializedChange) {
            this.serializedChange = serializedChange;
        }

        public void notifyModelChange(ModelChange modelChange) {
            if (this.serializedChange != null) {
                String receivedTriple = null;
                try {
                    receivedTriple = IOUtils.toString((InputStream)modelChange.getSerializedModel(), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Assert.assertEquals((Object)this.serializedChange, (Object)receivedTriple);
            } else {
                RDFServiceNotificationTest.this.modelChanges.add(modelChange);
            }
        }

        public void notifyEvent(String graphURI, Object event) {
        }
    }
}

