/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdatingModelTest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkModelCom;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkOntModelImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.BulkUpdatingOntModel;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.Arrays;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.junit.Test;

public class BulkUpdatingOntModelTest
extends AbstractBulkUpdatingModelTest {
    @Test
    public void testRemoveWithIterator() {
        OntModel wrappedModel = this.getWrappedModel();
        Model removeModel = VitroModelFactory.createModel();
        removeModel.add((Statement)this.getStatement());
        wrappedModel.remove(removeModel.listStatements());
    }

    @Test
    public void testRemoveStatementArray() {
        OntModel wrapModel = this.getWrappedModel();
        wrapModel.remove(new Statement[]{this.getStatement()});
    }

    @Test
    public void testRemoveStatementList() {
        OntModel wrapModel = this.getWrappedModel();
        wrapModel.remove(Arrays.asList(this.getStatement()));
    }

    @Test
    public void testAddWithIterator() {
        OntModel wrappedModel = this.getWrappedModel();
        Model model = VitroModelFactory.createModel();
        model.add((Statement)this.getStatement());
        wrappedModel.add(model.listStatements());
    }

    @Test
    public void testAddStatementArray() {
        OntModel wrapModel = this.getWrappedModel();
        wrapModel.add(new Statement[]{this.getStatement()});
    }

    @Test
    public void testAddStatementList() {
        OntModel wrapModel = this.getWrappedModel();
        wrapModel.add(Arrays.asList(this.getStatement()));
    }

    private OntModel getWrappedModel() {
        OntModel m = ModelFactory.createOntologyModel();
        RDFServiceModel rdfService = new RDFServiceModel((Model)m);
        RDFServiceGraph g = new RDFServiceGraph((RDFService)rdfService);
        BulkModelCom bareModel = new BulkModelCom((Graph)g);
        BulkOntModelImpl ontModel = new BulkOntModelImpl(OntModelSpec.OWL_MEM, (Model)bareModel);
        BulkUpdatingOntModel wrappedModel = new BulkUpdatingOntModel((OntModel)ontModel);
        wrappedModel.updater = new AbstractBulkUpdatingModelTest.WrappedUpdater(wrappedModel.updater);
        return wrappedModel;
    }
}

