/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.junit.Test;

public class RDFServiceImplTest {
    @Test
    public void getConcurrentGraphUrisTest() throws RDFServiceException, InterruptedException {
        Dataset testDataSet = DatasetFactory.createGeneral();
        Model m1 = VitroModelFactory.createModel();
        testDataSet.addNamedModel("test:init1", m1);
        Model m2 = VitroModelFactory.createModel();
        testDataSet.addNamedModel("test:init2", m2);
        RDFServiceModel rdfService = new RDFServiceModel(testDataSet);
        rdfService.getGraphURIs();
        long i = 0L;
        while (rdfService.rebuildGraphURICache) {
            Thread.sleep(10L);
            if ((i += 10L) <= 10000L) continue;
            throw new RuntimeException();
        }
        List uris = rdfService.getGraphURIs();
        Iterator iterator = uris.iterator();
        while (iterator.hasNext()) {
            Model m = VitroModelFactory.createModel();
            testDataSet.addNamedModel("test" + i, m);
            rdfService.rebuildGraphURICache = true;
            rdfService.getGraphURIs();
            while (rdfService.rebuildGraphURICache) {
                Thread.sleep(10L);
                if ((i += 10L) <= 20000L) continue;
                throw new RuntimeException();
            }
            iterator.next();
            ++i;
        }
    }
}

