/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.service;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaBundle;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaImplementation;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaServiceBean;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class CaptchaServiceBeanTest
extends AbstractTestClass {
    private final ConfigurationPropertiesStub props = new ConfigurationPropertiesStub();

    @Before
    public void createConfigurationProperties() {
        this.props.setProperty("captcha.enabled", "true");
        ServletContextStub ctx = new ServletContextStub();
        ConfigurationProperties.setInstance((ConfigurationProperties)this.props);
        HttpSessionStub session = new HttpSessionStub();
        session.setServletContext(ctx);
        HttpServletRequestStub httpServletRequest = new HttpServletRequestStub();
        httpServletRequest.setSession(session);
    }

    @Test
    public void getChallenge_MatchingCaptchaIdAndRemoteAddress_ReturnsCaptchaBundle() {
        String captchaId = "sampleCaptchaId";
        CaptchaBundle sampleChallenge = new CaptchaBundle("sampleB64Image", "sampleCode", captchaId);
        CaptchaServiceBean.getCaptchaChallenges().put((Object)captchaId, (Object)sampleChallenge);
        Optional result = CaptchaServiceBean.getChallenge((String)captchaId);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)sampleChallenge, result.get());
    }

    @Test
    public void getChallenge_NonMatchingCaptchaIdAndRemoteAddress_ReturnsEmptyOptional() {
        Optional result = CaptchaServiceBean.getChallenge((String)"nonMatchingId");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void addCaptchaRelatedFieldsToPageContext_recaptchaImpl() throws IOException {
        this.props.setProperty("captcha.implementation", "RECAPTCHAv2");
        HashMap context = new HashMap();
        CaptchaServiceBean.addCaptchaRelatedFieldsToPageContext(context);
        Assert.assertEquals((Object)"RECAPTCHAV2", context.get("captchaToUse"));
    }

    @Test
    public void addCaptchaRelatedFieldsToPageContext_nanocaptchaImpl() throws IOException {
        this.props.setProperty("captcha.implementation", "NANOCAPTCHA");
        HashMap context = new HashMap();
        CaptchaServiceBean.addCaptchaRelatedFieldsToPageContext(context);
        Assert.assertEquals((Object)"NANOCAPTCHA", context.get("captchaToUse"));
    }

    @Test
    public void getCaptchaImpl_EnabledCaptcha() {
        this.props.setProperty("captcha.enabled", "true");
        this.props.setProperty("captcha.implementation", "RECAPTCHAv2");
        CaptchaImplementation captchaImpl = CaptchaServiceBean.getCaptchaImpl();
        Assert.assertEquals((Object)CaptchaImplementation.RECAPTCHAV2, (Object)captchaImpl);
    }

    @Test
    public void getCaptchaImpl_DisabledCaptcha() {
        this.props.setProperty("captcha.enabled", "false");
        CaptchaImplementation captchaImpl = CaptchaServiceBean.getCaptchaImpl();
        Assert.assertEquals((Object)CaptchaImplementation.NONE, (Object)captchaImpl);
    }

    @Test
    public void getCaptchaImpl_DefaultImplementation() {
        this.props.setProperty("captcha.enabled", "true");
        this.props.setProperty("captcha.implementation", null);
        CaptchaImplementation captchaImpl = CaptchaServiceBean.getCaptchaImpl();
        Assert.assertEquals((Object)CaptchaImplementation.NANOCAPTCHA, (Object)captchaImpl);
    }

    @Test
    public void validateCaptcha_NoneValid() {
        this.props.setProperty("captcha.enabled", "false");
        boolean result = CaptchaServiceBean.validateCaptcha((String)"anyInput", (String)"anyChallengeId");
        Assert.assertTrue((boolean)result);
    }
}

