/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.service;

import edu.cornell.mannlib.vitro.webapp.beans.CaptchaBundle;
import edu.cornell.mannlib.vitro.webapp.beans.CaptchaServiceBean;
import edu.cornell.mannlib.vitro.webapp.beans.NanocaptchaProvider;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class NanocaptchaProviderTest {
    private final ConfigurationPropertiesStub props = new ConfigurationPropertiesStub();
    private final NanocaptchaProvider provider = new NanocaptchaProvider();

    @Before
    public void createConfigurationProperties() {
        this.props.setProperty("captcha.enabled", "true");
        ServletContextStub ctx = new ServletContextStub();
        ConfigurationProperties.setInstance((ConfigurationProperties)this.props);
        HttpSessionStub session = new HttpSessionStub();
        session.setServletContext(ctx);
        HttpServletRequestStub httpServletRequest = new HttpServletRequestStub();
        httpServletRequest.setSession(session);
    }

    @Test
    public void generateChallenge_ValidEasyChallengeGenerated() throws IOException {
        this.props.setProperty("nanocaptcha.difficulty", "easy");
        CaptchaBundle captchaBundle = this.provider.generateRefreshChallenge();
        Assert.assertNotNull((Object)captchaBundle);
        Assert.assertNotNull((Object)captchaBundle.getB64Image());
        Assert.assertNotNull((Object)captchaBundle.getCode());
        Assert.assertNotNull((Object)captchaBundle.getCaptchaId());
    }

    @Test
    public void generateChallenge_ValidEmptyChallengeGenerated() throws IOException {
        this.props.setProperty("nanocaptcha.difficulty", "");
        CaptchaBundle captchaBundle = this.provider.generateRefreshChallenge();
        Assert.assertNotNull((Object)captchaBundle);
        Assert.assertNotNull((Object)captchaBundle.getB64Image());
        Assert.assertNotNull((Object)captchaBundle.getCode());
        Assert.assertNotNull((Object)captchaBundle.getCaptchaId());
    }

    @Test
    public void generateChallenge_ValidInvalidDifficultyChallengeGenerated() throws IOException {
        this.props.setProperty("nanocaptcha.difficulty", "asdasdasd");
        CaptchaBundle captchaBundle = this.provider.generateRefreshChallenge();
        Assert.assertNotNull((Object)captchaBundle);
        Assert.assertNotNull((Object)captchaBundle.getB64Image());
        Assert.assertNotNull((Object)captchaBundle.getCode());
        Assert.assertNotNull((Object)captchaBundle.getCaptchaId());
    }

    @Test
    public void generateChallenge_ValidHardChallengeGenerated() throws IOException {
        this.props.setProperty("nanocaptcha.difficulty", "hard");
        CaptchaBundle captchaBundle = this.provider.generateRefreshChallenge();
        Assert.assertNotNull((Object)captchaBundle);
        Assert.assertNotNull((Object)captchaBundle.getB64Image());
        Assert.assertNotNull((Object)captchaBundle.getCode());
        Assert.assertNotNull((Object)captchaBundle.getCaptchaId());
    }

    @Test
    public void validateCaptcha_NanoCaptchaValid() {
        CaptchaBundle sampleChallenge = new CaptchaBundle("sampleB64Image", "validCode", "challengeId");
        CaptchaServiceBean.getCaptchaChallenges().put((Object)"challengeId", (Object)sampleChallenge);
        this.props.setProperty("captcha.implementation", "NANOCAPTCHA");
        boolean result = this.provider.validateCaptcha("validCode", "challengeId");
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void addCaptchaRelatedFieldsToPageContext_NanocaptchaImpl() throws IOException {
        HashMap context = new HashMap();
        this.provider.addCaptchaRelatedFieldsToPageContext(context);
        Assert.assertNull(context.get("siteKey"));
        Assert.assertNotNull(context.get("challenge"));
        Assert.assertNotNull(context.get("challengeId"));
    }
}

