/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.service;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.Recaptchav2Provider;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class Recaptchav2ProviderTest
extends AbstractTestClass {
    private final ConfigurationPropertiesStub props = new ConfigurationPropertiesStub();
    private final Recaptchav2Provider provider = new Recaptchav2Provider();

    @Before
    public void createConfigurationProperties() {
        this.props.setProperty("captcha.enabled", "true");
        ServletContextStub ctx = new ServletContextStub();
        ConfigurationProperties.setInstance((ConfigurationProperties)this.props);
        HttpSessionStub session = new HttpSessionStub();
        session.setServletContext(ctx);
        HttpServletRequestStub httpServletRequest = new HttpServletRequestStub();
        httpServletRequest.setSession(session);
    }

    @Test
    public void validateReCaptcha_InvalidResponse_ReturnsFalse() {
        this.props.setProperty("recaptcha.secretKey", "WRONG_SECRET_KEY");
        boolean result = this.provider.validateReCaptcha("invalidResponse");
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void addCaptchaRelatedFieldsToPageContext_RecaptchaImpl() throws IOException {
        this.props.setProperty("recaptcha.siteKey", "SITE_KEY");
        HashMap context = new HashMap();
        this.provider.addCaptchaRelatedFieldsToPageContext(context);
        Assert.assertNotNull(context.get("siteKey"));
        Assert.assertNull(context.get("challenge"));
        Assert.assertNull(context.get("challengeId"));
    }
}

