/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.jfact;

import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaModelUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.ReasonerConfiguration;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.TBoxReasoner;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.BasicTBoxReasonerDriver;
import edu.cornell.mannlib.vitro.webapp.tboxreasoner.impl.jfact.JFactTBoxReasoner;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.util.SAXParsers;

public class JFactTBoxReasonerTest {
    private static final String axioms = "@prefix obo: <http://purl.obolibrary.org/obo/> .\r\n@prefix owl: <http://www.w3.org/2002/07/owl#> .\r\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\r\n@prefix xml: <http://www.w3.org/XML/1998/namespace> .\r\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\r\n\r\n<http://vivo.mydomain.edu/individual/class_c> rdf:type owl:Class ;\r\n         \r\n         rdfs:subClassOf [ rdf:type owl:Class ;\r\n                           owl:intersectionOf ( <http://vivo.mydomain.edu/individual/class_a>\r\n                                                <http://vivo.mydomain.edu/individual/class_b>\r\n                                              )\r\n                         ] .\r\n\r\n<http://vivo.mydomain.edu/individual/class_a>\r\n        a                        owl:Class ;\r\n        rdfs:label               \"Class A\"@en-US .\r\n\r\n<http://vivo.mydomain.edu/individual/class_b>\r\n        a                        owl:Class ;\r\n        rdfs:label               \"Class B\"@en-US .\r\n\r\n<http://vivo.mydomain.edu/individual/class_c>\r\n        a                        owl:Class ;\r\n        rdfs:label               \"Class C\"@en-US .\r\n";

    @Before
    public void init() {
        LogManager.getLogger(SAXParsers.class).setLevel(Level.ERROR);
    }

    @After
    public void finish() {
        LogManager.getLogger(SAXParsers.class).setLevel(Level.INFO);
    }

    @Test
    public void testRemoveAxiomsWithBlankNodes() {
        OntModel tboxAssertions = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel tboxInferences = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel tboxUnion = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ModelFactory.createUnion((Model)tboxAssertions, (Model)tboxInferences));
        JFactTBoxReasoner reasoner = new JFactTBoxReasoner();
        BasicTBoxReasonerDriver driver = new BasicTBoxReasonerDriver(tboxAssertions, tboxInferences.getBaseModel(), tboxUnion, (TBoxReasoner)reasoner, ReasonerConfiguration.DEFAULT);
        Model additions = ModelFactory.createDefaultModel();
        additions.read((Reader)new StringReader(axioms), null, "TTL");
        Model subtractions = ModelFactory.createDefaultModel();
        subtractions.read((Reader)new StringReader(axioms), null, "TTL");
        Model incorrectSubtraction = additions.difference(subtractions);
        Assert.assertFalse((boolean)incorrectSubtraction.isEmpty());
        tboxAssertions.getBaseModel().add(additions);
        tboxAssertions.getBaseModel().notifyEvent((Object)new EditEvent(null, false));
        this.waitForTBoxReasoning(driver);
        Assert.assertTrue((tboxUnion.size() > additions.size() ? 1 : 0) != 0);
        JenaModelUtils.removeWithBlankNodesAsVariables((Model)subtractions, (Model)tboxAssertions.getBaseModel());
        tboxAssertions.getBaseModel().notifyEvent((Object)new EditEvent(null, false));
        this.waitForTBoxReasoning(driver);
        Assert.assertFalse((boolean)tboxUnion.contains(tboxUnion.getResource("http://vivo.mydomain.edu/individual/class_a"), null, (RDFNode)null));
        Assert.assertFalse((boolean)tboxUnion.contains(tboxUnion.getResource("http://vivo.mydomain.edu/individual/class_b"), null, (RDFNode)null));
        Assert.assertFalse((boolean)tboxUnion.contains(tboxUnion.getResource("http://vivo.mydomain.edu/individual/class_c"), null, (RDFNode)null));
    }

    private void waitForTBoxReasoning(BasicTBoxReasonerDriver driver) {
        for (int sleeps = 0; 0 == sleeps || sleeps < 1000 && driver.getStatus().isReasoning(); ++sleeps) {
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

