/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequestStub;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SimpleOntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SparqlQueryDataGetter;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.vocabulary.RDF;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class SparqlQueryDataGetterTest
extends AbstractTestClass {
    private static final String TO_FILTER = "toFilter";
    private static final PropertyImpl HAS_ID = new PropertyImpl("test:has-id");
    private static final String VAR_PARAM = "param";
    private static final String PERSON_TYPE = "http://xmlns.com/foaf/0.1/Person";
    private static final String PREFIX = "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#";
    private static final String BOB_URI = "http://example.com/p/bob";
    private static final Resource BOB = ResourceFactory.createResource((String)"http://example.com/p/bob");
    private static final String ALICE_URI = "http://example.com/p/alice";
    private static final Resource ALICE = ResourceFactory.createResource((String)"http://example.com/p/alice");
    OntModel displayModel;
    String testDataGetterURI_1 = "query1data";
    WebappDaoFactory wdf;
    VitroRequestStub vreq;
    private Map<String, Object> params;
    private OntModel dataModel;

    @Override
    @Before
    public void setUp() {
        SparqlQueryDataGetterTest.setLoggerLevel(RDFDefaultErrorHandler.class, Level.OFF);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        InputStream in = SparqlQueryDataGetterTest.class.getResourceAsStream("resources/dataGetterTest.n3");
        model.read(in, "", "N3");
        this.displayModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        SimpleOntModelSelector sos = new SimpleOntModelSelector(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM));
        sos.setDisplayModel(this.displayModel);
        this.wdf = new WebappDaoFactoryJena((OntModelSelector)sos);
        this.vreq = new VitroRequestStub(new HttpServletRequestStub());
        this.params = new HashMap<String, Object>();
        this.dataModel = VitroModelFactory.createOntologyModel();
    }

    @Test
    public void testBasicGetData() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter(this.testDataGetterURI_1);
        this.dataModel.add(BOB, RDF.type, (RDFNode)ResourceFactory.createResource((String)PERSON_TYPE));
        Map data = sdg.doQueryOnModel(sdg.queryText, (Model)this.dataModel);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithUriParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterUriParam");
        this.dataModel.add(BOB, RDF.type, (RDFNode)ResourceFactory.createResource((String)PERSON_TYPE));
        this.dataModel.add(ALICE, RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://xmlns.com/foaf/0.1/Agent"));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, PERSON_TYPE);
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithStringParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterStringParam");
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral("profile"));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral("car"));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, "profile");
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithIntParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterIntParam");
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(1));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(2));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, "1");
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithLongParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterLongParam");
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(1L));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(2L));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, "1");
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithFloatParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterFloatParam");
        Float value = Float.valueOf(1.1f);
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral((Object)value));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(1.2f));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, value.toString());
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithDoubleParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterDoubleParam");
        Double value = 1.1;
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral((Object)value));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(1.2));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, value.toString());
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testDataGetterWithBooleanParam() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterBooleanParam");
        Boolean value = true;
        this.dataModel.add(BOB, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral((Object)value));
        this.dataModel.add(ALICE, (Property)HAS_ID, (RDFNode)this.dataModel.createTypedLiteral(value == false));
        this.vreq.setRDFService((RDFService)new RDFServiceModel((Model)this.dataModel));
        this.params.put(VAR_PARAM, value.toString());
        Map data = sdg.getData(this.params);
        this.checkData(data);
    }

    @Test
    public void testFilterUnavailableParameters() throws Exception {
        SparqlQueryDataGetter sdg = this.getDataGetter("dataGetterStringParam");
        HashMap<String, String> unfilteredParameters = new HashMap<String, String>();
        unfilteredParameters.put(VAR_PARAM, "");
        unfilteredParameters.put(TO_FILTER, "");
        Map filteredParameters = sdg.filterUnavailableParameters(unfilteredParameters);
        Assert.assertFalse((boolean)filteredParameters.containsKey(TO_FILTER));
        Assert.assertTrue((boolean)filteredParameters.containsKey(VAR_PARAM));
    }

    private SparqlQueryDataGetter getDataGetter(String dataGetterName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        DataGetter dg = DataGetterUtils.dataGetterForURI((VitroRequest)this.vreq, (Model)this.displayModel, (String)(PREFIX + dataGetterName));
        Assert.assertNotNull((Object)dg);
        Assert.assertTrue((String)("DataGetter should be of type " + SparqlQueryDataGetter.class.getName()), (boolean)(dg instanceof SparqlQueryDataGetter));
        SparqlQueryDataGetter sdg = (SparqlQueryDataGetter)dg;
        return sdg;
    }

    private void checkData(Map<String, Object> data) {
        Assert.assertNotNull(data);
        Assert.assertTrue((String)"should contain key people", (boolean)data.containsKey("people"));
        Object obj = data.get("people");
        Assert.assertTrue((String)("people should be a List, it is " + obj.getClass().getName()), (boolean)(obj instanceof List));
        List people = (List)obj;
        Assert.assertEquals((long)1L, (long)people.size());
        Map first = (Map)people.get(0);
        Assert.assertEquals((Object)BOB_URI, first.get("uri"));
    }
}

