/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.beans;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginStatusBean {
    private static final Log log = LogFactory.getLog(LoginStatusBean.class);
    private static final LoginStatusBean DUMMY_BEAN = new LoginStatusBean("", AuthenticationSource.UNKNOWN);
    private static final String ATTRIBUTE_NAME = "loginStatus";
    private final String userURI;
    private final AuthenticationSource authenticationSource;

    public static void setBean(HttpSession session, LoginStatusBean lsb) {
        session.setAttribute(ATTRIBUTE_NAME, (Object)lsb);
    }

    public static LoginStatusBean getBean(HttpServletRequest request) {
        if (request == null) {
            return DUMMY_BEAN;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return DUMMY_BEAN;
        }
        return LoginStatusBean.getBean(session);
    }

    public static LoginStatusBean getBean(HttpSession session) {
        if (session == null) {
            return DUMMY_BEAN;
        }
        Object o = session.getAttribute(ATTRIBUTE_NAME);
        if (o == null) {
            return DUMMY_BEAN;
        }
        if (!(o instanceof LoginStatusBean)) {
            log.warn((Object)("Tried to get login status bean, but found an instance of " + o.getClass().getName() + ": " + o));
            return DUMMY_BEAN;
        }
        return (LoginStatusBean)o;
    }

    public static UserAccount getCurrentUser(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return LoginStatusBean.getCurrentUser(request.getSession(false));
    }

    public static UserAccount getCurrentUser(HttpSession session) {
        if (session == null) {
            return null;
        }
        if (!LoginStatusBean.getBean(session).isLoggedIn()) {
            return null;
        }
        WebappDaoFactory wadf = ModelAccess.getInstance().getWebappDaoFactory();
        UserAccountsDao userAccountsDao = wadf.getUserAccountsDao();
        if (userAccountsDao == null) {
            log.error((Object)"No UserAccountsDao");
            return null;
        }
        String userUri = LoginStatusBean.getBean(session).getUserURI();
        return userAccountsDao.getUserAccountByUri(userUri);
    }

    public LoginStatusBean(String userURI, AuthenticationSource authenticationSource) {
        this.userURI = userURI;
        this.authenticationSource = authenticationSource;
    }

    public String getUserURI() {
        return this.userURI;
    }

    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    public boolean isLoggedIn() {
        return this.authenticationSource != AuthenticationSource.UNKNOWN;
    }

    public boolean hasExternalAuthentication() {
        return this.authenticationSource == AuthenticationSource.EXTERNAL;
    }

    public String toString() {
        return "LoginStatusBean[userURI=" + this.userURI + ", authenticationSource=" + (Object)((Object)this.authenticationSource) + "]";
    }

    public static enum AuthenticationSource {
        UNKNOWN,
        INTERNAL,
        EXTERNAL;

    }
}

