/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.controller;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.NamedKeyComponent;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseEditController
extends VitroHttpServlet {
    private static final String OPERATIONS_TO_ROLES = "operationsToRoles";
    public static final String URI_SUPPRESSIONS = "uriSuppressions";
    public static final String TYPE_SUPPRESSIONS = "typeSuppressions";
    public static final String TYPE_SUPPRESSIONS_NOT_RELATED = "typeSuppressionsNotRelated";
    public static final String PROPERTY_SUPPRESSIONS_NOT_RELATED = "propertySuppressionsNotRelated";
    public static final String ENTITY_URI_ATTRIBUTE_NAME = "_permissionsEntityURI";
    public static final String ENTITY_TYPE_ATTRIBUTE_NAME = "_permissionsEntityType";
    public static final boolean FORCE_NEW = true;
    public static final String JSP_PREFIX = "/templates/edit/specific/";
    protected static DateFormat DISPLAY_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    protected static final int BASE_10 = 10;
    private static final Log log = LogFactory.getLog((String)BaseEditController.class.getName());
    private static final String DEFAULT_LANDING_PAGE = "/siteAdmin";
    protected static final String MULTIPLEXED_PARAMETER_NAME = "multiplexedParam";
    private final String EPO_HASH_ATTR = "epoHash";
    private final String EPO_KEYLIST_ATTR = "epoKeylist";
    private final int MAX_EPOS = 5;
    private final Calendar cal = Calendar.getInstance();

    protected EditProcessObject createEpo(HttpServletRequest request) {
        return this.createEpo(request, false);
    }

    protected EditProcessObject createEpo(HttpServletRequest request, boolean forceNew) {
        EditProcessObject epo = null;
        HashMap epoHash = this.getEpoHash(request);
        String existingEpoKey = request.getParameter("_epoKey");
        if (!forceNew && existingEpoKey != null && epoHash.get(existingEpoKey) != null) {
            epo = (EditProcessObject)epoHash.get(existingEpoKey);
            epo.setKey(existingEpoKey);
            epo.setUseRecycledBean(true);
        } else {
            LinkedList epoKeylist = this.getEpoKeylist(request);
            if (epoHash.size() == 5) {
                try {
                    epoHash.remove(epoKeylist.getFirst());
                    epoKeylist.removeFirst();
                }
                catch (Exception e) {
                    log.error((Object)"Error removing old EPO", (Throwable)e);
                }
            }
            Random rand = new Random();
            String epoKey = this.createEpoKey();
            while (epoHash.get(epoKey) != null) {
                epoKey = epoKey + Integer.toHexString(rand.nextInt());
            }
            epo = new EditProcessObject();
            epoHash.put(epoKey, epo);
            epoKeylist.add(epoKey);
            epo.setKey(epoKey);
            epo.setReferer(forceNew ? request.getRequestURL().append('?').append(request.getQueryString()).toString() : request.getHeader("Referer"));
            epo.setSession(request.getSession());
        }
        return epo;
    }

    private LinkedList getEpoKeylist(HttpServletRequest request) {
        return (LinkedList)request.getSession().getAttribute("epoKeylist");
    }

    private HashMap getEpoHash(HttpServletRequest request) {
        HashMap epoHash = (HashMap)request.getSession().getAttribute("epoHash");
        if (epoHash == null) {
            epoHash = new HashMap();
            request.getSession().setAttribute("epoHash", epoHash);
            LinkedList epoKeylist = new LinkedList();
            request.getSession().setAttribute("epoKeylist", epoKeylist);
        }
        return epoHash;
    }

    private String createEpoKey() {
        return Long.toHexString(this.cal.getTimeInMillis());
    }

    protected void setRequestAttributes(HttpServletRequest request, EditProcessObject epo) {
        VitroRequest vreq = new VitroRequest(request);
        request.setAttribute("epoKey", (Object)epo.getKey());
        request.setAttribute("epo", (Object)epo);
        request.setAttribute("globalErrorMsg", epo.getAttribute("globalErrorMsg"));
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
    }

    protected void populateBeanFromParams(Object bean, HttpServletRequest request) {
        Map params = request.getParameterMap();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String key = "";
            try {
                key = (String)paramNames.nextElement();
            }
            catch (ClassCastException cce) {
                log.error((Object)"populateBeanFromParams() could not cast parameter name to String");
            }
            String value = "";
            if (key.equals(MULTIPLEXED_PARAMETER_NAME)) {
                String multiplexedStr = request.getParameterValues(key)[0];
                Map<String, String> paramMap = FormUtils.beanParamMapFromString(multiplexedStr);
                for (String param : paramMap.keySet()) {
                    String demultiplexedValue = paramMap.get(param);
                    FormUtils.beanSet(bean, param, demultiplexedValue);
                }
                continue;
            }
            try {
                value = request.getParameterValues(key)[0];
            }
            catch (ClassCastException cce) {
                try {
                    value = ((Integer)params.get(key)).toString();
                }
                catch (ClassCastException ccf) {
                    log.error((Object)"populateBeanFromParams() could not cast parameter name to String");
                }
            }
            FormUtils.beanSet(bean, key, value);
        }
    }

    public List<Option> getSortedList(HashMap<String, Option> hashMap, List<Option> optionList, VitroRequest vreq) {
        ArrayList<String> bodyVal = new ArrayList<String>();
        ArrayList<Option> options = new ArrayList<Option>();
        for (Option option : optionList) {
            hashMap.put(option.getBody(), option);
            bodyVal.add(option.getBody());
        }
        class ListComparator
        implements Comparator<String> {
            Collator collator;

            public ListComparator(Collator collator) {
                this.collator = collator;
            }

            @Override
            public int compare(String str1, String str2) {
                return this.collator.compare(str1, str2);
            }
        }
        bodyVal.sort(new ListComparator(vreq.getCollator()));
        for (String aBodyVal : bodyVal) {
            options.add(hashMap.get(aBodyVal));
        }
        return options;
    }

    protected WebappDaoFactory getWebappDaoFactory() {
        return ModelAccess.getInstance().getWebappDaoFactory(ModelAccess.ReasoningOption.ASSERTIONS_ONLY);
    }

    protected WebappDaoFactory getWebappDaoFactory(String userURI) {
        return this.getWebappDaoFactory().getUserAwareDaoFactory(userURI);
    }

    public String getDefaultLandingPage(HttpServletRequest request) {
        return request.getContextPath() + DEFAULT_LANDING_PAGE;
    }

    protected static void addAccessAttributes(HttpServletRequest req, String entityURI, AccessObjectType aot) {
        req.setAttribute(ENTITY_URI_ATTRIBUTE_NAME, (Object)entityURI);
        String[] namedKeys = new String[]{};
        List<PermissionSet> permissionSets = BaseEditController.buildListOfSelectableRoles(ModelAccess.on(req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]));
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        for (PermissionSet permissionSet : permissionSets) {
            roles.add(new RoleInfo(permissionSet));
        }
        List<AccessOperation> accessOperations = AccessOperation.getOperations(aot);
        LinkedHashMap<String, LinkedList<RoleInfo>> operationsToRoles = new LinkedHashMap<String, LinkedList<RoleInfo>>();
        for (AccessOperation operation : accessOperations) {
            LinkedList<RoleInfo> roleInfos = new LinkedList<RoleInfo>();
            String operationName = StringUtils.capitalize((String)operation.toString().toLowerCase());
            operationsToRoles.put(operationName, roleInfos);
            for (RoleInfo role : roles) {
                RoleInfo roleCopy = role.clone();
                roleInfos.add(roleCopy);
                if (!BaseEditController.isPublicForbiddenOperation(operation) || !roleCopy.isPublic) continue;
                roleCopy.setEnabled(false);
                roleCopy.setGranted(false);
            }
            BaseEditController.getRolePolicyInformation(entityURI, aot, namedKeys, operation, roleInfos);
        }
        req.setAttribute(OPERATIONS_TO_ROLES, operationsToRoles);
    }

    private static void getRolePolicyInformation(String entityURI, AccessObjectType aot, String[] namedKeys, AccessOperation operation, List<RoleInfo> roleInfos) {
        if (!StringUtils.isEmpty((CharSequence)entityURI)) {
            for (RoleInfo roleInfo : roleInfos) {
                if (!roleInfo.isEnabled()) continue;
                roleInfo.setGranted(EntityPolicyController.isGranted(entityURI, aot, operation, roleInfo.getUri(), namedKeys));
            }
        }
    }

    protected static void addUriSuppressions(HttpServletRequest req, String entityURI, AccessObjectType aot) {
        AccessOperation operation = AccessOperation.DISPLAY;
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString()};
        List<PermissionSet> permissionSets = BaseEditController.buildListOfSelectableRoles(ModelAccess.on(req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]));
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        for (PermissionSet permissionSet : permissionSets) {
            roles.add(new RoleInfo(permissionSet));
        }
        LinkedHashMap<String, LinkedList<RoleInfo>> uriSuppressionsToRoles = new LinkedHashMap<String, LinkedList<RoleInfo>>();
        LinkedList<RoleInfo> roleInfos = new LinkedList<RoleInfo>();
        String operationName = StringUtils.capitalize((String)operation.toString().toLowerCase());
        uriSuppressionsToRoles.put(operationName, roleInfos);
        for (RoleInfo role : roles) {
            RoleInfo roleCopy = role.clone();
            roleInfos.add(roleCopy);
        }
        BaseEditController.getRolePolicyInformation(entityURI, aot, namedKeys, operation, roleInfos);
        req.setAttribute(URI_SUPPRESSIONS, uriSuppressionsToRoles);
        req.setAttribute(ENTITY_URI_ATTRIBUTE_NAME, (Object)entityURI);
    }

    protected static void addTypeSuppressions(HttpServletRequest req, String entityURI, AccessObjectType aot) {
        AccessOperation operation = AccessOperation.DISPLAY;
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_TYPE.toString()};
        List<PermissionSet> permissionSets = BaseEditController.buildListOfSelectableRoles(ModelAccess.on(req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]));
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        for (PermissionSet permissionSet : permissionSets) {
            roles.add(new RoleInfo(permissionSet));
        }
        LinkedHashMap<String, LinkedList<RoleInfo>> typeSuppressionsToRoles = new LinkedHashMap<String, LinkedList<RoleInfo>>();
        LinkedList<RoleInfo> roleInfos = new LinkedList<RoleInfo>();
        String operationName = StringUtils.capitalize((String)operation.toString().toLowerCase());
        typeSuppressionsToRoles.put(operationName, roleInfos);
        for (RoleInfo role : roles) {
            RoleInfo roleCopy = role.clone();
            roleInfos.add(roleCopy);
        }
        BaseEditController.getRolePolicyInformation(entityURI, aot, namedKeys, operation, roleInfos);
        req.setAttribute(TYPE_SUPPRESSIONS, typeSuppressionsToRoles);
    }

    protected static void addNotRelatedTypeSuppressions(HttpServletRequest req, String entityURI, AccessObjectType aot) {
        AccessOperation operation = AccessOperation.DISPLAY;
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_TYPE.toString(), NamedKeyComponent.NOT_RELATED.toString()};
        RoleInfo role = BaseEditController.getSelfEditorRole(req);
        LinkedHashMap<String, LinkedList<RoleInfo>> typeSuppressionsToRoles = new LinkedHashMap<String, LinkedList<RoleInfo>>();
        LinkedList<RoleInfo> roleInfos = new LinkedList<RoleInfo>();
        String operationName = StringUtils.capitalize((String)operation.toString().toLowerCase());
        typeSuppressionsToRoles.put(operationName, roleInfos);
        roleInfos.add(role);
        BaseEditController.getRolePolicyInformation(entityURI, aot, namedKeys, operation, roleInfos);
        req.setAttribute(TYPE_SUPPRESSIONS_NOT_RELATED, typeSuppressionsToRoles);
    }

    protected static RoleInfo getSelfEditorRole(HttpServletRequest req) {
        PermissionSet permissionSet = ModelAccess.on(req).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]).getUserAccountsDao().getPermissionSetByUri("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR");
        RoleInfo role = new RoleInfo(permissionSet);
        return role;
    }

    protected static void addNotRelatedPropertySuppressions(HttpServletRequest req, String entityURI, AccessObjectType aot) {
        AccessOperation operation = AccessOperation.DISPLAY;
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString(), NamedKeyComponent.NOT_RELATED.toString()};
        RoleInfo role = BaseEditController.getSelfEditorRole(req);
        LinkedHashMap<String, LinkedList<RoleInfo>> propertySuppressionsToRoles = new LinkedHashMap<String, LinkedList<RoleInfo>>();
        LinkedList<RoleInfo> roleInfos = new LinkedList<RoleInfo>();
        String operationName = StringUtils.capitalize((String)operation.toString().toLowerCase());
        propertySuppressionsToRoles.put(operationName, roleInfos);
        roleInfos.add(role);
        BaseEditController.getRolePolicyInformation(entityURI, aot, namedKeys, operation, roleInfos);
        req.setAttribute(PROPERTY_SUPPRESSIONS_NOT_RELATED, propertySuppressionsToRoles);
    }

    static boolean isPublicForbiddenOperation(AccessOperation operation) {
        return operation.equals((Object)AccessOperation.PUBLISH);
    }

    protected static List<PermissionSet> buildListOfSelectableRoles(WebappDaoFactory wadf) {
        ArrayList<PermissionSet> permissionSets = new ArrayList<PermissionSet>();
        for (PermissionSet ps : wadf.getUserAccountsDao().getAllPermissionSets()) {
            if (ps.isForPublic()) continue;
            permissionSets.add(ps);
        }
        permissionSets.sort(new Comparator<PermissionSet>(){

            @Override
            public int compare(PermissionSet ps1, PermissionSet ps2) {
                return ps1.getUri().compareTo(ps2.getUri());
            }
        });
        for (PermissionSet ps : wadf.getUserAccountsDao().getAllPermissionSets()) {
            if (!ps.isForPublic()) continue;
            permissionSets.add(ps);
        }
        return permissionSets;
    }

    public static class RoleInfo {
        String uri;
        String label;
        private boolean enabled = true;
        private boolean granted = true;
        private boolean isPublic;

        public RoleInfo(PermissionSet ps) {
            this.uri = ps.getUri();
            this.label = ps.getLabel();
            this.isPublic = ps.isForPublic();
        }

        public RoleInfo(String uri, String label, boolean isPublic) {
            this.uri = uri;
            this.label = label;
            this.isPublic = isPublic;
        }

        public String getUri() {
            return this.uri;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public void setGranted(boolean granted) {
            this.granted = granted;
        }

        public RoleInfo clone() {
            return new RoleInfo(this.uri, this.label, this.isPublic);
        }

        public boolean isPublic() {
            return this.isPublic;
        }
    }
}

