/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.controller;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.listener.ChangeListener;
import edu.cornell.mannlib.vedit.listener.EditPreProcessor;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.util.OperationUtils;
import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.NamedKeyComponent;
import edu.cornell.mannlib.vitro.webapp.auth.policy.EntityPolicyController;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="OperationController", urlPatterns={"/doEdit"})
public class OperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)OperationController.class.getName());
    private boolean SUCCESS = false;
    private boolean FAILURE = !this.SUCCESS;

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String defaultLandingPage = this.getDefaultLandingPage(request);
        HashMap epoHash = null;
        EditProcessObject epo = null;
        try {
            epoHash = (HashMap)request.getSession().getAttribute("epoHash");
            epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
        }
        catch (NullPointerException e) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException ioe) {
                log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
            }
            return;
        }
        if (epo == null) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException ioe) {
                log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
            }
            return;
        }
        if (request.getParameter("_cancel") != null) {
            String referer = epo.getReferer();
            if (referer == null) {
                try {
                    response.sendRedirect(defaultLandingPage);
                }
                catch (IOException ioe) {
                    log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
                }
                return;
            }
            try {
                response.sendRedirect(referer);
            }
            catch (IOException ioe) {
                log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
            }
            return;
        }
        if (request.getParameter("_reset") != null) {
            try {
                response.sendRedirect(request.getHeader("Referer"));
            }
            catch (IOException ioe) {
                log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
            }
            return;
        }
        try {
            Object newObj = this.getNewObj(epo);
            boolean valid = this.populateObjectFromRequestParamsAndValidate(epo, newObj, request);
            this.runPreprocessors(epo, newObj);
            epo.setNewBean(newObj);
            if (!valid) {
                epo.setAttribute("globalErrorMsg", "Please correct errors highlighted below.");
                this.retry(request, response, epo);
                return;
            }
            String action = this.getAction(request);
            boolean status = this.performEdit(epo, newObj, action);
            if (status == this.FAILURE) {
                this.retry(request, response, epo);
                return;
            }
            if (request.getParameter("_permissions") != null) {
                this.updatePermissions(request);
            }
            if (this.isUriSuppressionsPresent(request)) {
                this.updateUriSuppressions(request);
            }
            epo.setRequestParameterMap(request.getParameterMap());
            this.notifyChangeListeners(epo, action);
            switch (action) {
                case "insert": {
                    PageForwarder pipf = epo.getPostInsertPageForwarder();
                    if (pipf == null) break;
                    pipf.doForward(request, response, epo);
                    return;
                }
                case "update": {
                    PageForwarder pupf = epo.getPostUpdatePageForwarder();
                    if (pupf == null) break;
                    pupf.doForward(request, response, epo);
                    return;
                }
                case "delete": {
                    PageForwarder pdpf = epo.getPostDeletePageForwarder();
                    if (pdpf == null) break;
                    pdpf.doForward(request, response, epo);
                    return;
                }
            }
            String referer = epo.getReferer();
            if (referer == null) {
                response.sendRedirect(defaultLandingPage);
            } else {
                response.sendRedirect(referer);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error performing edit", (Throwable)e);
            String errMsg = e.getMessage() != null ? e.getMessage() : "Error performing edit";
            epo.setAttribute("globalErrorMsg", errMsg);
            try {
                this.retry(request, response, epo);
            }
            catch (IOException ioe) {
                log.error((Object)(this.getClass().getName() + " IOError on redirect: "), (Throwable)ioe);
            }
        }
    }

    private void updateUriSuppressions(HttpServletRequest request) {
        String entityUri = request.getParameter("_permissionsEntityURI");
        if (entityUri == null) {
            return;
        }
        String entityType = request.getParameter("_permissionsEntityType");
        AccessObjectType aot = this.getAccessObjectType(entityUri, entityType);
        if (aot == null) {
            return;
        }
        this.updateUriSuppressions(request, aot, entityUri);
    }

    private void updatePermissions(HttpServletRequest request) {
        String entityType;
        AccessObjectType aot;
        String entityUri = request.getParameter("_permissionsEntityURI");
        if (StringUtils.isEmpty((CharSequence)entityUri) && !StringUtils.isEmpty((CharSequence)request.getParameter("Namespace")) && !StringUtils.isEmpty((CharSequence)request.getParameter("LocalName"))) {
            entityUri = "" + request.getParameter("Namespace") + request.getParameter("LocalName");
        }
        if ((aot = this.getAccessObjectType(entityUri, entityType = request.getParameter("_permissionsEntityType"))) == null) {
            return;
        }
        this.updateEntityPermissions(request, entityUri, aot);
        this.updateTypeSuppressions(request, aot, entityUri);
        this.updateNotRelatedTypeSuppressions(request, aot, entityUri);
        this.updateNotRelatedPropertySuppressions(request, aot, entityUri);
    }

    private void updateEntityPermissions(HttpServletRequest request, String entityUri, AccessObjectType aot) {
        Set<BaseEditController.RoleInfo> roles = this.getAllRoles(request);
        List<AccessOperation> operations = AccessOperation.getOperations(aot);
        for (AccessOperation ao : operations) {
            String operationGroupName = ao.toString().toLowerCase();
            Set<String> selectedRoles = this.getSelectedRoles(request, operationGroupName);
            for (BaseEditController.RoleInfo role : roles) {
                if (role.isPublic() && OperationController.isPublicForbiddenOperation(ao)) continue;
                if (selectedRoles.contains(role.getUri())) {
                    EntityPolicyController.grantAccess(entityUri, aot, ao, role.getUri(), new String[0]);
                    continue;
                }
                EntityPolicyController.revokeAccess(entityUri, aot, ao, role.getUri(), new String[0]);
            }
        }
    }

    private Set<BaseEditController.RoleInfo> getAllRoles(HttpServletRequest request) {
        List<PermissionSet> permissionSets = OperationController.buildListOfSelectableRoles(ModelAccess.on(request).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]));
        HashSet<BaseEditController.RoleInfo> roles = new HashSet<BaseEditController.RoleInfo>();
        for (PermissionSet permissionSet : permissionSets) {
            roles.add(new BaseEditController.RoleInfo(permissionSet));
        }
        return roles;
    }

    private void updateUriSuppressions(HttpServletRequest request, AccessObjectType aot, String entityUri) {
        if (!AccessObjectType.INDIVIDUAL.equals((Object)aot)) {
            return;
        }
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString()};
        Set<BaseEditController.RoleInfo> roles = this.getAllRoles(request);
        String operationGroupName = "uriSuppression" + AccessOperation.DISPLAY.toString().toLowerCase();
        Set<String> selectedRoles = this.getSelectedRoles(request, operationGroupName);
        for (BaseEditController.RoleInfo role : roles) {
            if (selectedRoles.contains(role.getUri())) {
                EntityPolicyController.grantAccess(entityUri, aot, AccessOperation.DISPLAY, role.getUri(), namedKeys);
                continue;
            }
            EntityPolicyController.revokeAccess(entityUri, aot, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        }
    }

    private void updateTypeSuppressions(HttpServletRequest request, AccessObjectType aot, String entityUri) {
        if (!this.isTypeSuppressionsPresent(request) || !AccessObjectType.CLASS.equals((Object)aot)) {
            return;
        }
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_TYPE.toString()};
        Set<BaseEditController.RoleInfo> roles = this.getAllRoles(request);
        String operationGroupName = "typeSuppression" + AccessOperation.DISPLAY.toString().toLowerCase();
        Set<String> selectedRoles = this.getSelectedRoles(request, operationGroupName);
        for (BaseEditController.RoleInfo role : roles) {
            if (selectedRoles.contains(role.getUri())) {
                EntityPolicyController.grantAccess(entityUri, AccessObjectType.INDIVIDUAL, AccessOperation.DISPLAY, role.getUri(), namedKeys);
                continue;
            }
            EntityPolicyController.revokeAccess(entityUri, AccessObjectType.INDIVIDUAL, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        }
    }

    private void updateNotRelatedTypeSuppressions(HttpServletRequest request, AccessObjectType aot, String entityUri) {
        if (!this.isNotRelatedTypeSuppressionsPresent(request) || !AccessObjectType.CLASS.equals((Object)aot)) {
            return;
        }
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_TYPE.toString(), NamedKeyComponent.NOT_RELATED.toString()};
        BaseEditController.RoleInfo role = OperationController.getSelfEditorRole(request);
        String operationGroupName = "typeSuppressionNotRelated" + AccessOperation.DISPLAY.toString().toLowerCase();
        Set<String> selectedRoles = this.getSelectedRoles(request, operationGroupName);
        if (selectedRoles.contains(role.getUri())) {
            EntityPolicyController.grantAccess(entityUri, AccessObjectType.INDIVIDUAL, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        } else {
            EntityPolicyController.revokeAccess(entityUri, AccessObjectType.INDIVIDUAL, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        }
    }

    private void updateNotRelatedPropertySuppressions(HttpServletRequest request, AccessObjectType aot, String entityUri) {
        if (!this.isNotRelatedPropertySuppressionsPresent(request)) {
            return;
        }
        String[] namedKeys = new String[]{NamedKeyComponent.SUPPRESSION_BY_URI.toString(), NamedKeyComponent.NOT_RELATED.toString()};
        BaseEditController.RoleInfo role = OperationController.getSelfEditorRole(request);
        String operationGroupName = "propertySuppressionNotRelated" + AccessOperation.DISPLAY.toString().toLowerCase();
        Set<String> selectedRoles = this.getSelectedRoles(request, operationGroupName);
        if (selectedRoles.contains(role.getUri())) {
            EntityPolicyController.grantAccess(entityUri, aot, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        } else {
            EntityPolicyController.revokeAccess(entityUri, aot, AccessOperation.DISPLAY, role.getUri(), namedKeys);
        }
    }

    private boolean isUriSuppressionsPresent(HttpServletRequest request) {
        return request.getParameter("uriSuppressions") != null;
    }

    private boolean isNotRelatedPropertySuppressionsPresent(HttpServletRequest request) {
        return request.getParameter("propertySuppressionsNotRelated") != null;
    }

    private boolean isTypeSuppressionsPresent(HttpServletRequest request) {
        return request.getParameter("typeSuppressions") != null;
    }

    private boolean isNotRelatedTypeSuppressionsPresent(HttpServletRequest request) {
        return request.getParameter("typeSuppressionsNotRelated") != null;
    }

    private Set<String> getSelectedRoles(HttpServletRequest request, String operationGroupName) {
        String[] selectedRoles = request.getParameterValues(operationGroupName + "Roles");
        if (selectedRoles == null) {
            selectedRoles = new String[]{};
        }
        return new HashSet<String>(Arrays.asList(selectedRoles));
    }

    private AccessObjectType getAccessObjectType(String entityUri, String entityType) {
        AccessObjectType aot = null;
        if (StringUtils.isBlank((CharSequence)entityUri)) {
            log.error((Object)"EntityUri is blank");
        } else if (StringUtils.isBlank((CharSequence)entityType) || !EnumUtils.isValidEnum(AccessObjectType.class, (String)entityType)) {
            log.error((Object)("EntityType is not valid " + entityType));
        } else {
            aot = AccessObjectType.valueOf(entityType);
        }
        return aot;
    }

    private void retry(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) throws IOException {
        String referer = request.getHeader("Referer");
        String string = referer = referer == null ? epo.getReferer() : referer;
        if (referer != null) {
            int epoKeyIndex = referer.indexOf("_epoKey");
            if (epoKeyIndex >= 0) {
                String url = referer.substring(0, epoKeyIndex) + "_epoKey=" + request.getParameter("_epoKey");
                response.sendRedirect(url);
                return;
            }
            String redirectUrl = referer.indexOf("?") > -1 ? referer + "&" : referer + "?";
            redirectUrl = redirectUrl + "_epoKey=" + request.getParameter("_epoKey");
            response.sendRedirect(redirectUrl);
        } else {
            response.sendRedirect(this.getDefaultLandingPage(request));
        }
    }

    private void runPreprocessors(EditProcessObject epo, Object newObj) {
        if (epo.getPreProcessorList() != null && epo.getPreProcessorList().size() > 0) {
            for (EditPreProcessor epp : epo.getPreProcessorList()) {
                epp.process(newObj, epo);
            }
        }
    }

    private Object getNewObj(EditProcessObject epo) {
        Object newObj = null;
        if (epo.getOriginalBean() != null) {
            newObj = epo.getImplementationClass() != null ? OperationUtils.cloneBean(epo.getOriginalBean(), epo.getImplementationClass(), epo.getBeanClass()) : OperationUtils.cloneBean(epo.getOriginalBean());
        } else {
            Class<?> cls = epo.getBeanClass();
            try {
                newObj = cls.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Illegal access - see error logs.");
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Unable to instantiate " + cls.getSimpleName());
            }
        }
        epo.setNewBean(newObj);
        return newObj;
    }

    private boolean populateObjectFromRequestParamsAndValidate(EditProcessObject epo, Object newObj, HttpServletRequest request) {
        boolean valid = true;
        String currParam = "";
        Enumeration penum = request.getParameterNames();
        while (penum.hasMoreElements()) {
            List<Validator> validatorList;
            currParam = (String)penum.nextElement();
            if (currParam.indexOf("_") == 0) continue;
            String currValue = request.getParameterValues(currParam)[0];
            if (currValue.length() == 0 && request.getParameterValues(currParam).length > 1) {
                currValue = request.getParameterValues(currParam)[1];
            }
            boolean fieldValid = true;
            if (request.getParameter("_delete") == null && (validatorList = epo.getValidatorMap().get(currParam)) != null) {
                Iterator<Validator> valIt = validatorList.iterator();
                StringBuilder errMsg = new StringBuilder();
                while (valIt.hasNext()) {
                    Validator val = valIt.next();
                    ValidationObject vo = val.validate(currValue);
                    if (!vo.getValid()) {
                        valid = false;
                        fieldValid = false;
                        errMsg.append(vo.getMessage()).append(" ");
                        epo.getBadValueMap().put(currParam, currValue);
                        continue;
                    }
                    try {
                        epo.getBadValueMap().remove(currParam);
                        epo.getErrMsgMap().remove(currParam);
                    }
                    catch (Exception exception) {}
                }
                if (errMsg.length() > 0) {
                    epo.getErrMsgMap().put(currParam, errMsg.toString());
                    log.info((Object)("doPost() putting error message " + errMsg + " for " + currParam));
                }
            }
            if (!fieldValid) continue;
            if (currValue.length() == 0) {
                Map<String, String> defaultHash = epo.getDefaultValueMap();
                try {
                    String defaultValue = defaultHash.get(currParam);
                    if (defaultValue != null) {
                        currValue = defaultValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                FormUtils.beanSet(newObj, currParam, currValue, epo);
                epo.getErrMsgMap().remove(currParam);
                epo.getBadValueMap().remove(currParam);
            }
            catch (NumberFormatException e) {
                if (currValue.length() <= 0) continue;
                valid = false;
                epo.getErrMsgMap().put(currParam, "Please enter an integer");
                epo.getBadValueMap().put(currParam, currValue);
            }
            catch (FormUtils.NegativeIntegerException nie) {
                valid = false;
                epo.getErrMsgMap().put(currParam, "Please enter a positive integer");
                epo.getBadValueMap().put(currParam, currValue);
            }
            catch (IllegalArgumentException f) {
                valid = false;
                log.error((Object)("doPost() reports IllegalArgumentException for " + currParam));
                log.debug((Object)("doPost() error message: " + f.getMessage()));
                epo.getErrMsgMap().put(currParam, f.getMessage());
                epo.getBadValueMap().put(currParam, currValue);
            }
        }
        return valid;
    }

    private String getAction(HttpServletRequest request) {
        if (request.getParameter("_update") != null) {
            return "update";
        }
        if (request.getParameter("_delete") != null) {
            return "delete";
        }
        return "insert";
    }

    private void notifyChangeListeners(EditProcessObject epo, String action) {
        List<ChangeListener> changeListeners = epo.getChangeListenerList();
        if (changeListeners != null) {
            for (ChangeListener cl : changeListeners) {
                switch (action) {
                    case "insert": {
                        cl.doInserted(epo.getNewBean(), epo);
                        break;
                    }
                    case "update": {
                        cl.doUpdated(epo.getOriginalBean(), epo.getNewBean(), epo);
                        break;
                    }
                    case "delete": {
                        cl.doDeleted(epo.getOriginalBean(), epo);
                    }
                }
            }
        }
    }

    private boolean performEdit(EditProcessObject epo, Object newObj, String action) {
        String partialClassName = epo.getBeanClass() != null ? epo.getBeanClass().getSimpleName() : epo.getNewBean().getClass().getSimpleName();
        Object dataAccessObject = null;
        if (epo.getDataAccessObject() == null) {
            throw new RuntimeException(OperationController.class.getName() + " needs to be passed an EPO containing a data access object with which to perform the desired operation");
        }
        dataAccessObject = epo.getDataAccessObject();
        Class[] classList = new Class[]{epo.getBeanClass() != null ? epo.getBeanClass() : newObj.getClass()};
        newObj.getClass().getGenericSuperclass();
        Class[] superClassList = new Class[]{newObj.getClass().getSuperclass()};
        Method meth = null;
        Method deleteMeth = null;
        Method insertMeth = null;
        if ("update".equals(action)) {
            if (epo.getUpdateMethod() != null) {
                meth = epo.getUpdateMethod();
            } else {
                try {
                    meth = dataAccessObject.getClass().getMethod("update" + partialClassName, classList);
                }
                catch (NoSuchMethodException e) {
                    try {
                        meth = dataAccessObject.getClass().getMethod("update" + partialClassName, superClassList);
                    }
                    catch (NoSuchMethodException f) {
                        try {
                            deleteMeth = dataAccessObject.getClass().getMethod("delete" + partialClassName, classList);
                            try {
                                insertMeth = dataAccessObject.getClass().getMethod("insert" + partialClassName, classList);
                            }
                            catch (NoSuchMethodException ee) {
                                insertMeth = dataAccessObject.getClass().getMethod("insertNew" + partialClassName, classList);
                            }
                        }
                        catch (NoSuchMethodException g) {
                            log.error((Object)("doPost() could not find method(s) for updating " + partialClassName));
                        }
                    }
                }
            }
        } else if ("delete".equals(action)) {
            if (epo.getDeleteMethod() != null) {
                meth = epo.getDeleteMethod();
            } else {
                try {
                    meth = dataAccessObject.getClass().getMethod("delete" + partialClassName, classList);
                }
                catch (NoSuchMethodException e) {
                    try {
                        meth = dataAccessObject.getClass().getMethod("delete" + partialClassName, superClassList);
                    }
                    catch (NoSuchMethodException f) {
                        log.error((Object)("doPost() could not find method delete" + partialClassName + "() on " + dataAccessObject.getClass().getName()));
                    }
                }
            }
        } else if (epo.getInsertMethod() != null) {
            meth = epo.getInsertMethod();
        } else {
            try {
                meth = dataAccessObject.getClass().getMethod("insert" + partialClassName, classList);
            }
            catch (NoSuchMethodException e) {
                try {
                    meth = dataAccessObject.getClass().getMethod("insertNew" + partialClassName, classList);
                }
                catch (NoSuchMethodException f) {
                    try {
                        meth = dataAccessObject.getClass().getMethod("insertNew" + partialClassName, superClassList);
                    }
                    catch (NoSuchMethodException g) {
                        try {
                            meth = dataAccessObject.getClass().getMethod("insertNew" + partialClassName, superClassList);
                        }
                        catch (NoSuchMethodException h) {
                            log.error((Object)("doPost() could not find method for inserting " + partialClassName));
                        }
                    }
                }
            }
        }
        Object[] insArgList = new Object[]{newObj};
        Object result = null;
        if (meth == null && action.equals("update")) {
            try {
                Object[] delArgList = new Object[]{epo.getOriginalBean()};
                deleteMeth.invoke(dataAccessObject, delArgList);
                insertMeth.invoke(dataAccessObject, insArgList);
            }
            catch (InvocationTargetException e) {
                log.error((Object)(this.getClass().getName() + " encountered exception performing two-stage update"));
                Throwable innerE = e.getTargetException();
                log.error((Object)innerE, innerE);
                if (innerE.getMessage() != null) {
                    epo.setAttribute("globalErrorMsg", innerE.getMessage());
                }
                return this.FAILURE;
            }
            catch (IllegalAccessException iae) {
                log.error((Object)iae, (Throwable)iae);
                epo.setAttribute("globalErrorMessage", "Illegal access - see error logs.");
                return this.FAILURE;
            }
        }
        try {
            result = meth.invoke(dataAccessObject, insArgList);
        }
        catch (InvocationTargetException e) {
            log.error((Object)(this.getClass().getName() + " encountered exception performing edit action"));
            Throwable innerE = e.getTargetException();
            log.error((Object)innerE, innerE);
            if (innerE.getMessage() != null) {
                epo.setAttribute("globalErrorMsg", innerE.getMessage());
            }
            return this.FAILURE;
        }
        catch (IllegalAccessException iae) {
            log.error((Object)iae, (Throwable)iae);
            epo.setAttribute("globalErrorMessage", "Illegal access - see error logs.");
            return this.FAILURE;
        }
        if (result != null) {
            try {
                Class[] setIdArgs = new Class[]{epo.getIdFieldClass() != null ? epo.getIdFieldClass() : Integer.TYPE};
                String idMutator = "set";
                idMutator = epo.getIdFieldName() != null ? idMutator + epo.getIdFieldName() : idMutator + "Id";
                Method setIdMeth = epo.getNewBean().getClass().getMethod(idMutator, setIdArgs);
                try {
                    Object[] idArg = new Object[]{result};
                    setIdMeth.invoke(epo.getNewBean(), idArg);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"doPost() encountered IllegalAccessException setting id of new bean");
                }
                catch (InvocationTargetException f) {
                    log.error((Object)f.getTargetException().getMessage());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.SUCCESS;
    }
}

