/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit;

import edu.cornell.mannlib.vitro.webapp.audit.AuditChangeSet;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeListener;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;

public class AuditChangeListener
extends StatementListener
implements ModelChangedListener,
ChangeListener {
    private static final Log log = LogFactory.getLog(AuditChangeListener.class);

    @Override
    public void notifyModelChange(ModelChange modelChange) {
        Model changes = RDFServiceUtils.parseModel(modelChange.getSerializedModel(), modelChange.getSerializationFormat());
        AuditChangeSet auditChangeset = new AuditChangeSet();
        Model additions = auditChangeset.getAddedModel(modelChange.getGraphURI());
        String userId = modelChange.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            Exception e = new Exception();
            log.debug((Object)"User id is not provided.", (Throwable)e);
            userId = "http://vivoweb.org/audit/resource/unknown";
        }
        auditChangeset.setUserId(userId);
        if (modelChange.getOperation() == ModelChange.Operation.REMOVE) {
            additions.remove(changes);
            Model removed = auditChangeset.getRemovedModel(modelChange.getGraphURI());
            removed.add(changes);
        } else {
            additions.add(changes);
        }
        if (!auditChangeset.isEmpty()) {
            AuditDAOFactory.getAuditDAO().write(auditChangeset);
        }
    }

    @Override
    public void notifyEvent(String graphURI, Object event) {
    }
}

