/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit;

import java.io.StringWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;

public class AuditChangeSet {
    private final UUID id;
    private final Date requestTime;
    private Dataset addedDataset = null;
    private Dataset removedDataset = null;
    private String userId = "http://vivoweb.org/audit/resource/unknown";
    private String userEmail = "";
    private String userFirstName = "";
    private String userLastName = "";

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AuditChangeSet() {
        this.id = UUID.randomUUID();
        this.requestTime = new Date();
    }

    public AuditChangeSet(UUID id, Date requestTime) {
        this.id = id;
        this.requestTime = requestTime;
    }

    public UUID getUUID() {
        return this.id;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public Dataset getAddedDataset() {
        return this.addedDataset;
    }

    public Dataset getRemovedDataset() {
        return this.removedDataset;
    }

    public Model getAddedModel(String graphURI) {
        if (this.addedDataset == null) {
            this.addedDataset = DatasetFactory.createGeneral();
        }
        if (StringUtils.isEmpty((CharSequence)graphURI)) {
            return this.addedDataset.getDefaultModel();
        }
        return this.addedDataset.getNamedModel(graphURI);
    }

    public String getAddedStatements(String graphUri) {
        return this.getStatements(this.getAddedModel(graphUri));
    }

    public Model getRemovedModel(String graphURI) {
        if (this.removedDataset == null) {
            this.removedDataset = DatasetFactory.createGeneral();
        }
        if (StringUtils.isEmpty((CharSequence)graphURI)) {
            return this.removedDataset.getDefaultModel();
        }
        return this.removedDataset.getNamedModel(graphURI);
    }

    public String getRemovedStatements(String graphUri) {
        return this.getStatements(this.getRemovedModel(graphUri));
    }

    public boolean isEmpty() {
        if (this.addedDataset != null && !this.addedDataset.asDatasetGraph().isEmpty()) {
            return false;
        }
        return this.removedDataset == null || this.removedDataset.asDatasetGraph().isEmpty();
    }

    public Set<String> getGraphUris() {
        HashSet<String> graphUris = new HashSet<String>();
        this.populateGraphUriSet(graphUris, this.addedDataset);
        this.populateGraphUriSet(graphUris, this.removedDataset);
        return graphUris;
    }

    private void populateGraphUriSet(Set<String> graphUris, Dataset dataset) {
        if (dataset == null) {
            return;
        }
        Iterator iterator = dataset.listNames();
        while (iterator.hasNext()) {
            graphUris.add((String)iterator.next());
        }
    }

    private String getStatements(Model model) {
        if (model != null) {
            StringWriter sw = new StringWriter();
            RDFDataMgr.write((StringWriter)sw, (Model)model, (RDFFormat)RDFFormat.NTRIPLES);
            return sw.toString();
        }
        return "";
    }
}

