/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.audit.AuditChangeListener;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebListener
public class AuditSetup
implements ServletContextListener {
    private static final AuditChangeListener CHANGE_LISTENER = new AuditChangeListener();
    private static final Log log = LogFactory.getLog((String)AuditSetup.class.getName());

    public void contextInitialized(ServletContextEvent sce) {
        if (this.isAuditEnabled()) {
            ServletContext ctx = sce.getServletContext();
            RDFService contentRdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONTENT);
            this.registerChangeListener(contentRdfService);
            RDFService configurationRdfService = ModelAccess.on(ctx).getRDFService(ModelAccess.WhichService.CONFIGURATION);
            this.registerChangeListener(configurationRdfService);
        }
    }

    protected synchronized void registerChangeListener(RDFService rdfService) {
        try {
            rdfService.registerListener(CHANGE_LISTENER);
        }
        catch (RDFServiceException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private boolean isAuditEnabled() {
        try {
            return ApplicationUtils.instance().getAuditModule() != null;
        }
        catch (IllegalStateException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

