/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.audit.AuditModule;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOFactory;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOTDB;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import java.nio.file.Path;

public class TDBAuditModule
implements AuditModule {
    String tdbPath;

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTdbDirectory", minOccurs=1, maxOccurs=1)
    public void setTdbPath(String path) {
        this.tdbPath = path;
    }

    @Override
    public void startup(Application application, ComponentStartupStatus css) {
        Path vitroHome = ApplicationUtils.instance().getHomeDirectory().getPath();
        String resolvedPath = vitroHome.resolve(this.tdbPath).toString();
        AuditDAOTDB.initialize(resolvedPath);
        AuditDAOFactory.initialize(AuditDAOFactory.Storage.AUDIT_TDB);
    }

    @Override
    public void shutdown(Application application) {
        AuditDAOTDB.shutdown();
    }
}

