/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit.controller;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.audit.AuditChangeSet;
import edu.cornell.mannlib.vitro.webapp.audit.AuditResults;
import edu.cornell.mannlib.vitro.webapp.audit.ListAddedStatementsMethod;
import edu.cornell.mannlib.vitro.webapp.audit.ListRemovedStatementsMethod;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAO;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOFactory;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="AuditViewer", urlPatterns={"/audit/*"})
public class AuditController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(AuditController.class);
    private static final String TEMPLATE_DEFAULT = "auditHistory.ftl";
    private static final String PARAM_OFFSET = "offset";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_GRAPH = "graph";
    private static final String PARAM_ORDER = "order";
    private static final String PARAM_START_DATE = "start_date";
    private static final String PARAM_END_DATE = "end_date";
    private static final String PARAM_USER_URI = "user";
    private static final String DESC_ORDER = "DESC";
    private static final String ASC_ORDER = "ASC";
    private static final String[] limits = new String[]{"10", "30", "50", "100", "1000"};
    private static final String[] orders = new String[]{"ASC", "DESC"};
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if (log.isDebugEnabled()) {
            this.dumpRequestParameters((HttpServletRequest)vreq);
        }
        UserAccountsDao uad = ModelAccess.on((HttpServletRequest)vreq).getWebappDaoFactory(new ModelAccess.WebappDaoFactoryOption[0]).getUserAccountsDao();
        HashMap<String, Object> body = new HashMap<String, Object>();
        UserAccount acc = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
        if (acc == null || !this.isAdmin(acc)) {
            return new TemplateResponseValues("error-standard.ftl", body);
        }
        int offset = this.getOffset(vreq);
        body.put(PARAM_OFFSET, offset);
        int limit = this.getLimit(vreq);
        body.put(PARAM_LIMIT, String.valueOf(limit));
        body.put("limits", limits);
        Date startDate = this.getStartDate(vreq);
        body.put(PARAM_START_DATE, this.sdf.format(startDate));
        Date endDate = this.getEndDate(vreq);
        body.put(PARAM_END_DATE, this.sdf.format(endDate));
        String userUri = this.getUserUri(vreq);
        body.put("userUri", userUri);
        String graphUri = this.getGraph(vreq);
        body.put("selectedGraphUri", graphUri);
        String order = this.getOrder(vreq);
        body.put(PARAM_ORDER, order);
        body.put("orders", orders);
        AuditDAO auditDAO = AuditDAOFactory.getAuditDAO();
        AuditResults results = auditDAO.find(offset, limit, this.dateToTimeStamp(startDate), this.dateToTimeStamp(endDate), userUri, graphUri, ASC_ORDER.equals(order));
        List<String> users = auditDAO.getUsers();
        body.put("users", users);
        List<String> graphUris = auditDAO.getGraphs();
        body.put("graphs", graphUris);
        this.setUserData(results.getDatasets(), uad);
        body.put("results", results);
        if (offset > 0) {
            body.put("prevPage", this.getPreviousPageLink(offset, limit, this.sdf.format(startDate), this.sdf.format(endDate), order, userUri, graphUri, vreq.getServletPath()));
        }
        if ((long)offset < results.getTotal() - (long)limit) {
            body.put("nextPage", this.getNextPageLink(offset, limit, this.sdf.format(startDate), this.sdf.format(endDate), order, userUri, graphUri, vreq.getServletPath()));
        }
        if (StringUtils.isNotEmpty((CharSequence)acc.getFirstName())) {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{acc.getLastName()})) {
                body.put("username", acc.getFirstName() + " " + acc.getLastName());
            } else {
                body.put("username", acc.getFirstName());
            }
        } else if (StringUtils.isNotEmpty((CharSequence)acc.getEmailAddress())) {
            body.put("username", acc.getEmailAddress());
        } else {
            body.put("username", "");
        }
        body.put("listAddedStatements", new ListAddedStatementsMethod());
        body.put("listRemovedStatements", new ListRemovedStatementsMethod());
        return new TemplateResponseValues(TEMPLATE_DEFAULT, body);
    }

    private boolean isAdmin(UserAccount acc) {
        if (acc.isRootUser()) {
            return true;
        }
        Set<String> roles = acc.getPermissionSetUris();
        return roles.contains("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#ADMIN");
    }

    private void setUserData(List<AuditChangeSet> list, UserAccountsDao uad) {
        for (AuditChangeSet acs : list) {
            UserAccount account = uad.getUserAccountByUri(acs.getUserId());
            if (account == null) continue;
            acs.setUserFirstName(account.getFirstName());
            acs.setUserLastName(account.getLastName());
            acs.setUserEmail(account.getEmailAddress());
        }
    }

    private int getLimit(VitroRequest vreq) {
        int limit = 0;
        try {
            limit = Integer.parseInt(vreq.getParameter(PARAM_LIMIT));
        }
        catch (Throwable e) {
            log.debug((Object)e, e);
            limit = 10;
        }
        return limit;
    }

    private int getOffset(VitroRequest vreq) {
        int offset = 0;
        try {
            offset = Integer.parseInt(vreq.getParameter(PARAM_OFFSET));
        }
        catch (Throwable e) {
            log.debug((Object)e, e);
        }
        return offset;
    }

    private Date getStartDate(VitroRequest vreq) {
        String start = vreq.getParameter(PARAM_START_DATE);
        try {
            if (!StringUtils.isBlank((CharSequence)start)) {
                return this.sdf.parse(start);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return DateUtils.addDays((Date)new Date(), (int)-7);
    }

    private Date getEndDate(VitroRequest vreq) {
        String end = vreq.getParameter(PARAM_END_DATE);
        try {
            if (!StringUtils.isBlank((CharSequence)end)) {
                return this.sdf.parse(end);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return DateUtils.addDays((Date)new Date(), (int)1);
    }

    private String getUserUri(VitroRequest vreq) {
        String user = vreq.getParameter(PARAM_USER_URI);
        if (user == null) {
            return "";
        }
        return user;
    }

    private String getGraph(VitroRequest vreq) {
        String graph = vreq.getParameter(PARAM_GRAPH);
        if (graph == null) {
            return "";
        }
        return graph;
    }

    private String getOrder(VitroRequest vreq) {
        String order = vreq.getParameter(PARAM_ORDER);
        if (StringUtils.isBlank((CharSequence)order) || DESC_ORDER.equals(order)) {
            return DESC_ORDER;
        }
        return ASC_ORDER;
    }

    private String getPreviousPageLink(int offset, int limit, String startDate, String endDate, String order, String userUri, String graphUri, String baseUrl) {
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        params.put(PARAM_OFFSET, String.valueOf(offset - limit));
        params.put(PARAM_LIMIT, String.valueOf(limit));
        params.put(PARAM_START_DATE, startDate);
        params.put(PARAM_END_DATE, endDate);
        params.put(PARAM_ORDER, order);
        params.put(PARAM_USER_URI, userUri);
        params.put(PARAM_GRAPH, graphUri);
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private String getNextPageLink(int offset, int limit, String startDate, String endDate, String order, String userUri, String graphUri, String baseUrl) {
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap();
        params.put(PARAM_OFFSET, String.valueOf(offset + limit));
        params.put(PARAM_LIMIT, String.valueOf(limit));
        params.put(PARAM_START_DATE, String.valueOf(startDate));
        params.put(PARAM_END_DATE, endDate);
        params.put(PARAM_ORDER, order);
        params.put(PARAM_USER_URI, userUri);
        params.put(PARAM_GRAPH, graphUri);
        return UrlBuilder.getUrl(baseUrl, params);
    }

    private long dateToTimeStamp(Date date) {
        return date.getTime() / 1000L;
    }
}

