/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit.storage;

import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAO;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOTDB;

public class AuditDAOFactory {
    private static Storage storage;

    public static void initialize(Storage storage) {
        if (AuditDAOFactory.storage != null) {
            throw new IllegalStateException("AuditDAOFactory already initialized");
        }
        AuditDAOFactory.storage = storage;
    }

    public static void shutdown() {
        storage = null;
    }

    public static AuditDAO getAuditDAO() {
        if (storage == null) {
            throw new IllegalStateException("AuditDAOFactory not initialized");
        }
        switch (storage) {
            case AUDIT_TDB: {
                return new AuditDAOTDB();
            }
        }
        throw new UnsupportedOperationException("Unsupported Audit storage");
    }

    public static enum Storage {
        AUDIT_TDB;

    }
}

