/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit.storage;

import edu.cornell.mannlib.vitro.webapp.audit.AuditChangeSet;
import edu.cornell.mannlib.vitro.webapp.audit.AuditResults;
import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;

public abstract class AuditDAOJena
implements AuditDAO {
    private static final String auditGraph = "http://vivoweb.org/audit";
    private static final String changesBaseURI = "http://vivoweb.org/audit/changes/";

    protected abstract Dataset getDataset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(AuditChangeSet changes) {
        if (changes.getAddedDataset().asDatasetGraph().isEmpty() && changes.getRemovedDataset().asDatasetGraph().isEmpty()) {
            return;
        }
        Dataset auditStore = this.getDataset();
        if (auditStore == null) {
            return;
        }
        auditStore.begin(ReadWrite.WRITE);
        try {
            Model auditModel = auditStore.getNamedModel(auditGraph);
            if (auditModel == null) {
                return;
            }
            String changeUri = changesBaseURI + changes.getUUID().toString();
            Resource changeResource = auditModel.createResource(changeUri);
            changeResource.addProperty(RDF.type, (RDFNode)auditModel.createResource("http://vivoweb.org/audit/types/ChangeSet"));
            changeResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#uuid"), changes.getUUID().toString());
            changeResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#user"), (RDFNode)auditModel.createResource(changes.getUserId()));
            changeResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#date"), Long.toString(changes.getRequestTime().getTime(), 10));
            Set<String> names = changes.getGraphUris();
            int graphCount = 1;
            for (String graphName : names) {
                String removedName;
                Model removedAuditModel;
                String addedName;
                Model addedAuditModel;
                Model addedModel = changes.getAddedModel(graphName);
                Model removedModel = changes.getRemovedModel(graphName);
                if (this.isEmpty(addedModel) && this.isEmpty(removedModel)) continue;
                String graphUri = changeUri + "/graph/" + Integer.toString(graphCount, 10);
                Resource graphResource = auditModel.createResource(graphUri);
                changeResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#hasGraph"), (RDFNode)graphResource);
                graphResource.addProperty(RDF.type, (RDFNode)auditModel.createResource("http://vivoweb.org/audit/types/ChangeSetForGraph"));
                if (!StringUtils.isEmpty((CharSequence)graphName)) {
                    graphResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#graph"), (RDFNode)auditModel.createResource(graphName));
                }
                if (!this.isEmpty(addedModel) && (addedAuditModel = auditStore.getNamedModel(addedName = graphUri + "/added")) != null) {
                    addedAuditModel.add(addedModel);
                    graphResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#added"), (RDFNode)auditModel.createResource(addedName));
                }
                if (!this.isEmpty(removedModel) && (removedAuditModel = auditStore.getNamedModel(removedName = graphUri + "/removed")) != null) {
                    removedAuditModel.add(removedModel);
                    graphResource.addProperty(auditModel.createProperty("http://vivoweb.org/audit/properties#removed"), (RDFNode)auditModel.createResource(removedName));
                }
                ++graphCount;
            }
            auditStore.commit();
        }
        finally {
            auditStore.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditResults find(long offset, int limit, long startDate, long endDate, String userUri, String graphUri, boolean order) {
        long total = 0L;
        ArrayList<AuditChangeSet> datasets = new ArrayList<AuditChangeSet>();
        Dataset auditStore = this.getDataset();
        if (auditStore == null) {
            return null;
        }
        auditStore.begin(ReadWrite.READ);
        try {
            QuerySolution qs;
            ResultSet rs;
            ParameterizedSparqlString pss = this.createChangeSetsQuery(offset, limit, startDate, endDate, userUri, graphUri, order);
            Query query = QueryFactory.create((String)pss.toString());
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)auditStore.getNamedModel(auditGraph));
            try {
                rs = qexec.execSelect();
                while (rs.hasNext()) {
                    qs = rs.next();
                    String uri = qs.getResource("dataset").getURI();
                    datasets.add(this.getChangeSet(auditStore, uri));
                }
            }
            finally {
                qexec.close();
                query.clone();
            }
            pss = this.createChangeSetCountQuery(startDate, endDate, userUri, graphUri);
            query = QueryFactory.create((String)pss.toString());
            qexec = QueryExecutionFactory.create((Query)query, (Model)auditStore.getNamedModel(auditGraph));
            try {
                rs = qexec.execSelect();
                while (rs.hasNext()) {
                    qs = rs.next();
                    total = qs.getLiteral("datasetCount").getLong();
                }
            }
            finally {
                qexec.close();
                query.clone();
            }
        }
        finally {
            auditStore.end();
        }
        return new AuditResults(total, offset, limit, datasets);
    }

    private ParameterizedSparqlString createChangeSetCountQuery(long startDate, long endDate, String userUri, String graphUri) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.append("SELECT (COUNT(?dataset) AS ?datasetCount)\n");
        this.startWhere(pss);
        this.addType(pss);
        this.addDate(pss);
        this.addUserUri(userUri, pss);
        this.addGraphUri(graphUri, pss);
        this.addStartDate(startDate, pss);
        this.addEndDate(endDate, pss);
        this.endWhere(pss);
        return pss;
    }

    private ParameterizedSparqlString createChangeSetsQuery(long offset, int limit, long startDate, long endDate, String userUri, String graphUri, boolean order) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.append("SELECT ?dataset\n");
        this.startWhere(pss);
        this.addType(pss);
        this.addDate(pss);
        this.addUserUri(userUri, pss);
        this.addGraphUri(graphUri, pss);
        this.addStartDate(startDate, pss);
        this.addEndDate(endDate, pss);
        this.endWhere(pss);
        this.addOrder(order, pss);
        pss.append("LIMIT " + limit + " OFFSET " + offset);
        return pss;
    }

    private void addDate(ParameterizedSparqlString pss) {
        pss.append("  ?dataset <http://vivoweb.org/audit/properties#date> ?date .\n");
    }

    private void addType(ParameterizedSparqlString pss) {
        pss.append("  ?dataset a <http://vivoweb.org/audit/types/ChangeSet> .\n");
    }

    private void startWhere(ParameterizedSparqlString pss) {
        pss.append("WHERE {\n");
    }

    private void endWhere(ParameterizedSparqlString pss) {
        pss.append(" }");
    }

    private void addOrder(boolean order, ParameterizedSparqlString pss) {
        if (order) {
            pss.append("ORDER BY ASC(?date)\n");
        } else {
            pss.append("ORDER BY DESC(?date)\n");
        }
    }

    private void addEndDate(long endDate, ParameterizedSparqlString pss) {
        if (endDate > 0L) {
            pss.append("  FILTER ( ?date <= ?endDate )\n");
            pss.setLiteral("endDate", Long.toString(endDate));
        }
    }

    private void addStartDate(long startDate, ParameterizedSparqlString pss) {
        if (startDate > 0L) {
            pss.append("  FILTER ( ?date >= ?startDate )\n");
            pss.setLiteral("startDate", Long.toString(startDate));
        }
    }

    private void addGraphUri(String graphUri, ParameterizedSparqlString pss) {
        if (!StringUtils.isBlank((CharSequence)graphUri)) {
            pss.append("  ?dataset <http://vivoweb.org/audit/properties#hasGraph> ?graph .\n");
            pss.append("  ?graph <http://vivoweb.org/audit/properties#graph> ?graphUri .\n");
            pss.setIri("graphUri", graphUri);
        }
    }

    private void addUserUri(String userUri, ParameterizedSparqlString pss) {
        if (!StringUtils.isBlank((CharSequence)userUri)) {
            pss.append("  ?dataset <http://vivoweb.org/audit/properties#user> ?userUri .\n");
            pss.setIri("userUri", userUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsers() {
        LinkedList<String> users = new LinkedList<String>();
        Dataset auditStore = this.getDataset();
        if (auditStore == null) {
            return users;
        }
        auditStore.begin(ReadWrite.READ);
        try {
            StringBuilder queryString = new StringBuilder();
            queryString.append("SELECT DISTINCT ?userUri ");
            queryString.append(" WHERE {");
            queryString.append("   ?dataset <").append("http://vivoweb.org/audit/properties#user").append("> ?userUri . ");
            queryString.append(" } ");
            Query query = QueryFactory.create((String)queryString.toString());
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)auditStore.getNamedModel(auditGraph));){
                ResultSet rs = qexec.execSelect();
                while (rs.hasNext()) {
                    String uri;
                    QuerySolution qs = rs.next();
                    RDFNode user = qs.get("userUri");
                    if (!user.isResource() || (uri = user.asResource().getURI()) == null) continue;
                    users.add(uri);
                }
            }
        }
        finally {
            auditStore.end();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGraphs() {
        LinkedList<String> users = new LinkedList<String>();
        Dataset auditStore = this.getDataset();
        if (auditStore == null) {
            return users;
        }
        auditStore.begin(ReadWrite.READ);
        try {
            StringBuilder queryString = new StringBuilder();
            queryString.append("SELECT DISTINCT ?graphUri ");
            queryString.append(" WHERE {");
            queryString.append("   ?dataset <").append("http://vivoweb.org/audit/properties#graph").append("> ?graphUri . ");
            queryString.append(" } ");
            Query query = QueryFactory.create((String)queryString.toString());
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)auditStore.getNamedModel(auditGraph));){
                ResultSet rs = qexec.execSelect();
                while (rs.hasNext()) {
                    String uri;
                    QuerySolution qs = rs.next();
                    RDFNode user = qs.get("graphUri");
                    if (!user.isResource() || (uri = user.asResource().getURI()) == null) continue;
                    users.add(uri);
                }
            }
        }
        finally {
            auditStore.end();
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuditChangeSet getChangeSet(Dataset auditStore, String changesetUri) {
        if (StringUtils.isEmpty((CharSequence)changesetUri)) {
            return null;
        }
        UUID id = null;
        String userId = null;
        Date time = null;
        ArrayList<String> graphUris = new ArrayList<String>();
        Model auditModel = auditStore.getNamedModel(auditGraph);
        if (auditModel == null) {
            return null;
        }
        Resource datasetResource = auditModel.getResource(changesetUri);
        if (datasetResource != null) {
            try (StmtIterator iter = datasetResource.listProperties();){
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    switch (stmt.getPredicate().getURI()) {
                        case "http://vivoweb.org/audit/properties#uuid": {
                            id = UUID.fromString(stmt.getObject().asLiteral().toString());
                            break;
                        }
                        case "http://vivoweb.org/audit/properties#date": {
                            time = new Date(stmt.getObject().asLiteral().getLong());
                            break;
                        }
                        case "http://vivoweb.org/audit/properties#hasGraph": {
                            graphUris.add(stmt.getObject().asResource().getURI());
                            break;
                        }
                        case "http://vivoweb.org/audit/properties#user": {
                            userId = stmt.getObject().asResource().getURI();
                        }
                    }
                    stmt.getObject();
                }
            }
        }
        AuditChangeSet auditChangeSet = new AuditChangeSet(id, time);
        auditChangeSet.setUserId(userId);
        for (String graphUri : graphUris) {
            Model writeTo;
            String graphName = null;
            String addedGraph = null;
            String removedGraph = null;
            Resource graphResource = auditModel.getResource(graphUri);
            try (StmtIterator iter = graphResource.listProperties();){
                while (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    switch (stmt.getPredicate().getURI()) {
                        case "http://vivoweb.org/audit/properties#graph": {
                            graphName = stmt.getObject().asResource().getURI();
                            break;
                        }
                        case "http://vivoweb.org/audit/properties#added": {
                            addedGraph = stmt.getObject().asResource().getURI();
                            break;
                        }
                        case "http://vivoweb.org/audit/properties#removed": {
                            removedGraph = stmt.getObject().asResource().getURI();
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty(addedGraph)) {
                Model added = auditStore.getNamedModel(addedGraph);
                writeTo = auditChangeSet.getAddedModel(graphName);
                if (writeTo != null && added != null) {
                    writeTo.add(added);
                }
            }
            if (StringUtils.isEmpty(removedGraph)) continue;
            Model removed = auditStore.getNamedModel(removedGraph);
            writeTo = auditChangeSet.getRemovedModel(graphName);
            if (writeTo == null || removed == null) continue;
            writeTo.add(removed);
        }
        return auditChangeSet;
    }

    private boolean isEmpty(Model model) {
        return model == null || model.isEmpty();
    }
}

