/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.audit.storage;

import edu.cornell.mannlib.vitro.webapp.audit.storage.AuditDAOJena;
import java.io.File;
import org.apache.jena.query.Dataset;
import org.apache.jena.tdb.TDBFactory;

public class AuditDAOTDB
extends AuditDAOJena {
    private static Dataset dataset = null;

    public static void initialize(String tdbPath) {
        if (dataset != null) {
            throw new IllegalStateException("Already initialised AuditDAOTDB");
        }
        File dir = new File(tdbPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.isFile()) {
            throw new IllegalStateException("Path for the Audit TDB models must be a directory, not a file");
        }
        dataset = TDBFactory.createDataset((String)tdbPath);
    }

    public static void shutdown() {
        if (dataset != null) {
            TDBFactory.release((Dataset)dataset);
            dataset.close();
            dataset = null;
        }
    }

    @Override
    protected Dataset getDataset() {
        return dataset;
    }
}

