/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.dao.UserAccountsDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RootUserSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(RootUserSetup.class);
    private static final String PROPERTY_ROOT_USER_EMAIL = "rootUser.emailAddress";
    private static final String PROPERTY_ROOT_USER_PASSWORD = "rootUser.password";
    private static final String PROPERTY_ROOT_USER_PASSWORD_CHANGE_REQUIRED = "rootUser.passwordChangeRequired";
    private static final String ROOT_USER_INITIAL_PASSWORD = "rootPassword";
    private static final String ROOT_USER_INITIAL_PASSWORD_CHANGE_REQUIRED = "true";
    private ServletContext ctx;
    private StartupStatus ss;
    private UserAccountsDao uaDao;
    private ConfigurationProperties cp;
    private String configuredRootUser;
    private boolean configuredRootUserExists;
    private TreeSet<String> otherRootUsers;

    public void contextInitialized(ServletContextEvent sce) {
        this.ctx = sce.getServletContext();
        this.ss = StartupStatus.getBean(this.ctx);
        this.cp = ConfigurationProperties.getBean(this.ctx);
        try {
            this.uaDao = ModelAccess.on(this.ctx).getWebappDaoFactory().getUserAccountsDao();
            this.configuredRootUser = this.getRootEmailFromConfig();
            this.otherRootUsers = this.getEmailsOfAllRootUsers();
            this.configuredRootUserExists = this.otherRootUsers.remove(this.configuredRootUser);
            if (this.configuredRootUserExists) {
                if (this.otherRootUsers.isEmpty()) {
                    this.informThatRootUserExists();
                } else {
                    this.complainAboutMultipleRootUsers();
                }
            } else {
                this.createRootUser();
                if (!this.otherRootUsers.isEmpty()) {
                    this.complainAboutWrongRootUsers();
                }
            }
        }
        catch (Exception e) {
            this.ss.fatal(this, "Failed to set up the RootUserPolicy", e);
        }
    }

    private String getRootEmailFromConfig() {
        String email = ConfigurationProperties.getBean(this.ctx).getProperty(PROPERTY_ROOT_USER_EMAIL);
        if (email == null) {
            throw new IllegalStateException("runtime.properties must contain a value for 'rootUser.emailAddress'");
        }
        return email;
    }

    private TreeSet<String> getEmailsOfAllRootUsers() {
        TreeSet<String> rootUsers = new TreeSet<String>();
        for (UserAccount ua : this.uaDao.getAllUserAccounts()) {
            if (!ua.isRootUser()) continue;
            rootUsers.add(ua.getEmailAddress());
        }
        return rootUsers;
    }

    private void createRootUser() {
        if (!Authenticator.isValidEmailAddress(this.configuredRootUser)) {
            throw new IllegalStateException("Value for 'rootUser.emailAddress' is not a valid email address: '" + this.configuredRootUser + "'");
        }
        if (null != this.uaDao.getUserAccountByEmail(this.configuredRootUser)) {
            throw new IllegalStateException("Can't create root user - an account already exists with email address '" + this.configuredRootUser + "'");
        }
        UserAccount ua = new UserAccount();
        ua.setEmailAddress(this.configuredRootUser);
        ua.setFirstName("root");
        ua.setLastName("user");
        ua.setArgon2Password(Authenticator.applyArgon2iEncoding(this.getRootPasswordFromConfig()));
        ua.setMd5Password("");
        ua.setPasswordChangeRequired((boolean)this.getRootPasswdChangeRequiredFromConfig());
        ua.setStatus(UserAccount.Status.ACTIVE);
        ua.setRootUser(true);
        this.uaDao.insertUserAccount(ua);
        StartupStatus.getBean(this.ctx).info(this, "Created root user '" + this.configuredRootUser + "'");
    }

    private void informThatRootUserExists() {
        this.ss.info(this, "Root user is " + this.configuredRootUser);
    }

    private void complainAboutMultipleRootUsers() {
        for (String other : this.otherRootUsers) {
            this.ss.warning(this, "runtime.properties specifies '" + this.configuredRootUser + "' as the value for '" + PROPERTY_ROOT_USER_EMAIL + "', but the system also contains this root user: " + other);
        }
        this.ss.warning(this, "For security, it is best to delete unneeded root user accounts.");
    }

    private void complainAboutWrongRootUsers() {
        for (String other : this.otherRootUsers) {
            this.ss.warning(this, "runtime.properties specifies '" + this.configuredRootUser + "' as the value for '" + PROPERTY_ROOT_USER_EMAIL + "', but the system contains this root user instead: " + other);
        }
        this.ss.warning(this, "Creating root user '" + this.configuredRootUser + "'");
        this.ss.warning(this, "For security, it is best to delete unneeded root user accounts.");
    }

    private String getRootPasswordFromConfig() {
        String passwd = ConfigurationProperties.getBean(this.ctx).getProperty(PROPERTY_ROOT_USER_PASSWORD);
        if (passwd == null) {
            passwd = ROOT_USER_INITIAL_PASSWORD;
        }
        return passwd;
    }

    private Boolean getRootPasswdChangeRequiredFromConfig() {
        String passwdCR = ConfigurationProperties.getBean(this.ctx).getProperty(PROPERTY_ROOT_USER_PASSWORD_CHANGE_REQUIRED);
        if (passwdCR == null) {
            passwdCR = ROOT_USER_INITIAL_PASSWORD_CHANGE_REQUIRED;
        }
        return new Boolean(passwdCR);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

