/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.attributes;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessObjectType;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AccessOperation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class AttributeValueKey {
    private AccessOperation accessOperation;
    private AccessObjectType accessObjectType;
    private String role;
    private String type;
    private Set<String> namedKeyComponents = new HashSet<String>();

    public Set<String> getNamedKeyComponents() {
        return this.namedKeyComponents;
    }

    public AttributeValueKey() {
    }

    public AttributeValueKey(AccessOperation ao, AccessObjectType aot, String role, String type, String ... namedKeyComponents) {
        this.accessOperation = ao;
        this.accessObjectType = aot;
        this.role = role;
        this.type = type;
        this.namedKeyComponents = new HashSet<String>(Arrays.asList(namedKeyComponents));
    }

    public AttributeValueKey(AccessOperation ao, AccessObjectType aot, String role, String type, Set<String> namedKeyComponents) {
        this.accessOperation = ao;
        this.accessObjectType = aot;
        this.role = role;
        this.type = type;
        this.namedKeyComponents = namedKeyComponents;
    }

    public AccessOperation getAccessOperation() {
        return this.accessOperation;
    }

    public void setOperation(AccessOperation ao) {
        this.accessOperation = ao;
    }

    public AccessObjectType getObjectType() {
        return this.accessObjectType;
    }

    public void setObjectType(AccessObjectType aot) {
        this.accessObjectType = aot;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addNamedKey(String key) {
        this.namedKeyComponents.add(key);
    }

    public AttributeValueKey clone() {
        return new AttributeValueKey(this.accessOperation, this.accessObjectType, this.role, this.type, this.namedKeyComponents);
    }

    public boolean isEmpty() {
        return this.accessOperation == null && this.accessObjectType == null && this.role == null && this.type == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeValueKey)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AttributeValueKey compared = (AttributeValueKey)object;
        return new EqualsBuilder().append((Object)this.getAccessOperation(), (Object)compared.getAccessOperation()).append((Object)this.getObjectType(), (Object)compared.getObjectType()).append((Object)this.getRole(), (Object)compared.getRole()).append((Object)this.getType(), (Object)compared.getType()).append(this.getNamedKeyComponents(), compared.getNamedKeyComponents()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(151, 1017).append((Object)this.getAccessOperation()).append((Object)this.getObjectType()).append((Object)this.getRole()).append((Object)this.getType()).append(this.getNamedKeyComponents()).toHashCode();
    }
}

