/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.attributes;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AttributeValueSetRegistry {
    private static AttributeValueSetRegistry INSTANCE = new AttributeValueSetRegistry();
    private Map<AttributeValueKey, AttributeValueSet> valuesMap = new ConcurrentHashMap<AttributeValueKey, AttributeValueSet>();

    private AttributeValueSetRegistry() {
        INSTANCE = this;
    }

    public static AttributeValueSetRegistry getInstance() {
        return INSTANCE;
    }

    public AttributeValueSet get(AttributeValueKey key) {
        return this.valuesMap.get(key);
    }

    public void put(AttributeValueKey key, AttributeValueSet values) {
        this.valuesMap.put(key, values);
    }

    public void clear() {
        this.valuesMap.clear();
    }
}

