/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.attributes;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MutableAttributeValueSet
implements AttributeValueSet {
    private Set<String> values = ConcurrentHashMap.newKeySet();
    private String valueSetUri;
    private String type;
    private AttributeValueKey key;
    private String dataSetUri;

    @Override
    public void setValueSetUri(String valueSetUri) {
        this.valueSetUri = valueSetUri;
    }

    public MutableAttributeValueSet(String value) {
        this.values.add(value);
    }

    @Override
    public String getValueSetUri() {
        return this.valueSetUri;
    }

    @Override
    public void add(String value) {
        if (value == null) {
            return;
        }
        this.values.add(value);
    }

    @Override
    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        return this.values.contains(value);
    }

    @Override
    public boolean containsSingleValue() {
        return this.values.size() == 1;
    }

    @Override
    public String getSingleValue() {
        Iterator<String> iterator = this.values.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return "";
    }

    @Override
    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public void remove(String value) {
        this.values.remove(value);
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public void setKey(AttributeValueKey valueSetKey) {
        this.key = valueSetKey;
    }

    @Override
    public void setDataSetUri(String dataSetUri) {
        this.dataSetUri = dataSetUri;
    }
}

