/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.attributes;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSetRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.MutableAttributeValueSet;
import java.util.Optional;
import org.apache.jena.query.QuerySolution;

public class ValueSetFactory {
    public static AttributeValueSet create(String value, QuerySolution qs, AttributeValueKey dataSetKey) {
        Optional<String> type = ValueSetFactory.getSetElementsType(qs);
        if (!type.isPresent() || dataSetKey == null || dataSetKey.isEmpty()) {
            return new MutableAttributeValueSet(value);
        }
        AttributeValueKey avcKey = ValueSetFactory.getAttributeValueSetKey(dataSetKey, type.get());
        AttributeValueSet avc = AttributeValueSetRegistry.getInstance().get(avcKey);
        if (avc == null) {
            return ValueSetFactory.createNew(value, qs, dataSetKey, avcKey);
        }
        Optional<String> setUri = ValueSetFactory.getSetUri(qs);
        if (!setUri.isPresent() || !setUri.get().equals(avc.getValueSetUri())) {
            return ValueSetFactory.createNew(value, qs, dataSetKey, avcKey);
        }
        return ValueSetFactory.returnFromRegistry(value, avc);
    }

    private static AttributeValueSet returnFromRegistry(String value, AttributeValueSet avc) {
        avc.clear();
        avc.add(value);
        return avc;
    }

    private static AttributeValueSet createNew(String value, QuerySolution qs, AttributeValueKey dataSetKey, AttributeValueKey avcKey) {
        Optional<String> dataSetUri;
        Optional<String> type;
        MutableAttributeValueSet avc = new MutableAttributeValueSet(value);
        Optional<String> setUri = ValueSetFactory.getSetUri(qs);
        if (setUri.isPresent()) {
            avc.setValueSetUri(setUri.get());
        }
        if ((type = ValueSetFactory.getSetElementsType(qs)).isPresent()) {
            avc.setType(type.get());
        }
        if ((dataSetUri = ValueSetFactory.getDataSetUri(qs)).isPresent()) {
            avc.setDataSetUri(dataSetUri.get());
        }
        avc.setKey(dataSetKey);
        ValueSetFactory.register(avc, avcKey);
        return avc;
    }

    private static AttributeValueKey getAttributeValueSetKey(AttributeValueKey dataSetKey, String type) {
        AttributeValueKey avcKey = dataSetKey.clone();
        avcKey.setType(type);
        return avcKey;
    }

    private static void register(AttributeValueSet avc, AttributeValueKey key) {
        AttributeValueSetRegistry.getInstance().put(key, avc);
    }

    private static Optional<String> getSetUri(QuerySolution qs) {
        if (qs.contains("attributeValue") && qs.get("attributeValue").isResource()) {
            String uri = qs.getResource("attributeValue").getURI();
            return Optional.of(uri);
        }
        return Optional.empty();
    }

    private static Optional<String> getSetElementsType(QuerySolution qs) {
        if (qs.contains("setElementsType") && qs.get("setElementsType").isLiteral()) {
            String setElementsType = qs.getLiteral("setElementsType").getString();
            return Optional.of(setElementsType);
        }
        return Optional.empty();
    }

    private static Optional<String> getDataSetUri(QuerySolution qs) {
        if (qs.contains("dataSetUri") && qs.get("dataSetUri").isResource()) {
            String dataSetUri = qs.getResource("dataSetUri").getURI();
            return Optional.of(dataSetUri);
        }
        return Optional.empty();
    }
}

