/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.CheckType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class AbstractCheck
implements Check {
    private AttributeValueSet values;
    private String uri;
    private long computationalCost;
    private String configuration;
    private CheckType testType = CheckType.EQUALS;

    public AbstractCheck(String uri, AttributeValueSet values) {
        this.uri = uri;
        this.values = values;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public CheckType getType() {
        return this.testType;
    }

    @Override
    public void setType(CheckType testType) {
        this.testType = testType;
        this.adjustComputationCost(testType);
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @Override
    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public AttributeValueSet getValues() {
        return this.values;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractCheck)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AbstractCheck compared = (AbstractCheck)object;
        return new EqualsBuilder().append((Object)this.getUri(), (Object)compared.getUri()).append((Object)this.getValues(), (Object)compared.getValues()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 101).append((Object)this.getUri()).append((Object)this.getValues()).toHashCode();
    }

    @Override
    public long getComputationalCost() {
        return this.computationalCost;
    }

    private void adjustComputationCost(CheckType testType) {
        switch (testType) {
            case EQUALS: {
                this.computationalCost = 1L;
                return;
            }
            case NOT_EQUALS: {
                this.computationalCost = 2L;
                return;
            }
            case ONE_OF: {
                this.computationalCost = 100L;
                return;
            }
            case NOT_ONE_OF: {
                this.computationalCost = 101L;
                return;
            }
            case STARTS_WITH: {
                this.computationalCost = 1000L;
                return;
            }
            case SPARQL_SELECT_QUERY_RESULTS_CONTAIN: {
                this.computationalCost = 10000L;
                return;
            }
            case SPARQL_SELECT_QUERY_RESULTS_NOT_CONTAIN: {
                this.computationalCost = 10001L;
                return;
            }
        }
    }
}

