/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.Attribute;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AbstractCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AttributeValueChecker;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessObjectUriCheck
extends AbstractCheck {
    private static final Log log = LogFactory.getLog(AccessObjectUriCheck.class);

    public AccessObjectUriCheck(String uri, AttributeValueSet set) {
        super(uri, set);
    }

    @Override
    public boolean check(AuthorizationRequest ar) {
        AccessObject ao = ar.getAccessObject();
        Optional<String> inputValue = ao.getUri();
        if (!inputValue.isPresent()) {
            log.debug((Object)"Checked access object uri is not present.");
            return false;
        }
        String uri = inputValue.get();
        if (AttributeValueChecker.test(this, ar, uri)) {
            log.debug((Object)("Attribute match requested '" + uri + "'"));
            return true;
        }
        log.debug((Object)("Attribute don't match requested '" + uri + "'"));
        return false;
    }

    @Override
    public Attribute getAttributeType() {
        return Attribute.ACCESS_OBJECT_URI;
    }
}

