/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.CheckType;
import edu.cornell.mannlib.vitro.webapp.auth.checks.SparqlSelectQueryResultsChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;

public class AttributeValueChecker {
    static boolean test(Check attr, AuthorizationRequest ar, String ... values) {
        CheckType testType = attr.getType();
        switch (testType) {
            case EQUALS: {
                return AttributeValueChecker.equals(attr, values);
            }
            case NOT_EQUALS: {
                return !AttributeValueChecker.equals(attr, values);
            }
            case ONE_OF: {
                return AttributeValueChecker.contains(attr, values);
            }
            case NOT_ONE_OF: {
                return !AttributeValueChecker.contains(attr, values);
            }
            case STARTS_WITH: {
                return AttributeValueChecker.startsWith(attr, values);
            }
            case SPARQL_SELECT_QUERY_RESULTS_CONTAIN: {
                return SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain(attr, ar, values);
            }
            case SPARQL_SELECT_QUERY_RESULTS_NOT_CONTAIN: {
                return !SparqlSelectQueryResultsChecker.sparqlSelectQueryResultsContain(attr, ar, values);
            }
        }
        return false;
    }

    private static boolean contains(Check attr, String ... inputValues) {
        AttributeValueSet values = attr.getValues();
        for (String inputValue : inputValues) {
            if (!values.contains(inputValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Check attr, String ... inputValues) {
        AttributeValueSet values = attr.getValues();
        if (!values.containsSingleValue()) {
            return false;
        }
        for (String inputValue : inputValues) {
            if (!values.contains(inputValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(Check attr, String ... inputValues) {
        AttributeValueSet values = attr.getValues();
        if (!values.containsSingleValue()) {
            return false;
        }
        String value = values.getSingleValue();
        for (String inputValue : inputValues) {
            if (inputValue == null || !inputValue.startsWith(value)) continue;
            return true;
        }
        return false;
    }
}

