/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.Attribute;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueKey;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.ValueSetFactory;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AbstractCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AccessObjectTypeCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AccessObjectUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.CheckType;
import edu.cornell.mannlib.vitro.webapp.auth.checks.OperationCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.StatementObjectUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.StatementPredicateUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.StatementSubjectUriCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.SubjectRoleCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.SubjectTypeCheck;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;

public class CheckFactory {
    public static Check createCheck(QuerySolution qs, AttributeValueKey dataSetKey) {
        String typeId = qs.getLiteral("typeId").getString();
        String checkUri = qs.getResource("check").getURI();
        Attribute type = Attribute.valueOf(typeId);
        String testId = qs.getLiteral("testId").getString();
        String value = CheckFactory.getValue(qs);
        AttributeValueSet set = ValueSetFactory.create(value, qs, dataSetKey);
        AbstractCheck check = null;
        switch (type) {
            case SUBJECT_ROLE_URI: {
                check = new SubjectRoleCheck(checkUri, set);
                break;
            }
            case OPERATION: {
                check = new OperationCheck(checkUri, set);
                break;
            }
            case ACCESS_OBJECT_URI: {
                check = new AccessObjectUriCheck(checkUri, set);
                break;
            }
            case ACCESS_OBJECT_TYPE: {
                check = new AccessObjectTypeCheck(checkUri, set);
                break;
            }
            case SUBJECT_TYPE: {
                check = new SubjectTypeCheck(checkUri, set);
                break;
            }
            case STATEMENT_PREDICATE_URI: {
                check = new StatementPredicateUriCheck(checkUri, set);
                break;
            }
            case STATEMENT_SUBJECT_URI: {
                check = new StatementSubjectUriCheck(checkUri, set);
                break;
            }
            case STATEMENT_OBJECT_URI: {
                check = new StatementObjectUriCheck(checkUri, set);
                break;
            }
            default: {
                check = null;
            }
        }
        check.setType(CheckType.valueOf(testId));
        CheckFactory.setConfiguration(qs, check);
        return check;
    }

    private static void setConfiguration(QuerySolution qs, Check check) {
        RDFNode rdfNode = qs.get("config");
        if (rdfNode == null || !rdfNode.isLiteral()) {
            return;
        }
        check.setConfiguration(rdfNode.asLiteral().toString());
    }

    private static String getValue(QuerySolution qs) {
        if (!qs.contains("lit_value") || !qs.get("lit_value").isLiteral()) {
            String value = qs.getResource("value").getURI();
            return value;
        }
        String value = qs.getLiteral("lit_value").toString();
        return value;
    }

    public static void extendAttribute(Check check, QuerySolution qs) throws Exception {
        String testId = qs.getLiteral("testId").getString();
        if (CheckType.ONE_OF.toString().equals(testId) || CheckType.NOT_ONE_OF.toString().equals(testId)) {
            check.addValue(CheckFactory.getValue(qs));
            return;
        }
        throw new IllegalArgumentException(String.format("Operator '%s' can't be used in combination with multiple attribute values.", testId));
    }
}

