/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.Check;
import edu.cornell.mannlib.vitro.webapp.auth.checks.QueryResultsMapCache;
import edu.cornell.mannlib.vitro.webapp.auth.objects.AccessObject;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;

public class SparqlSelectQueryResultsChecker {
    private static final String PROFILE_URI = "profileUri";
    private static final String EXTERNAL_AUTH_ID = "externalAuthId";
    private static final String MATCHING_PROPERTY_URI = "matchingPropertyUri";
    private static final String OBJECT_URI = "objectUri";
    private static final Log log = LogFactory.getLog(SparqlSelectQueryResultsChecker.class);

    public static boolean sparqlSelectQueryResultsContain(Check check, AuthorizationRequest ar, String[] inputValues) {
        String query = check.getConfiguration();
        if (StringUtils.isBlank((CharSequence)query) && StringUtils.isBlank((CharSequence)(query = check.getValues().getSingleValue()))) {
            log.error((Object)"Sparql query is empty.");
            return false;
        }
        AccessObject ao = ar.getAccessObject();
        Model m = ao.getModel();
        if (m == null) {
            log.error((Object)"Model not provided");
            return false;
        }
        HashSet<String> comparedValues = new HashSet<String>();
        if (SparqlSelectQueryResultsChecker.isQueryNotProvidedInConfiguration(check)) {
            SparqlSelectQueryResultsChecker.addRelatedUrisToComparedValues(ao, comparedValues);
        } else {
            SparqlSelectQueryResultsChecker.addValuesToComparedValues(check.getValues(), comparedValues);
        }
        if (SparqlSelectQueryResultsChecker.isProfileUriRelatedQuery(query)) {
            return SparqlSelectQueryResultsChecker.makeProfileUriMatchQuery(ar, query, m, comparedValues);
        }
        if (query.contains("?externalAuthId") && SparqlSelectQueryResultsChecker.externalAuthIdIsNotAvailable(ar)) {
            SparqlSelectQueryResultsChecker.logVariableNotAvailable(EXTERNAL_AUTH_ID);
            return false;
        }
        if (query.contains("?matchingPropertyUri") && SparqlSelectQueryResultsChecker.matchingPropertyUriIsNotAvailable()) {
            SparqlSelectQueryResultsChecker.logVariableNotAvailable(MATCHING_PROPERTY_URI);
            return false;
        }
        Set<String> sparqlResults = SparqlSelectQueryResultsChecker.getSparqlSelectResults(m, "", query, ar);
        sparqlResults.retainAll(comparedValues);
        return !sparqlResults.isEmpty();
    }

    private static boolean makeProfileUriMatchQuery(AuthorizationRequest ar, String queryTemplate, Model m, Set<String> comparedValues) {
        boolean result = false;
        HashSet<String> profileUris = new HashSet<String>(ar.getEditorUris());
        if (profileUris.isEmpty()) {
            log.debug((Object)"Subject has no person Uri, nothing to substitute.");
            result = false;
        }
        for (String profileUri : profileUris) {
            Set<String> sparqlResults = SparqlSelectQueryResultsChecker.getSparqlSelectResults(m, profileUri, queryTemplate, ar);
            sparqlResults.retainAll(comparedValues);
            if (sparqlResults.isEmpty()) continue;
            result = true;
        }
        return result;
    }

    private static void addValuesToComparedValues(AttributeValueSet values, Set<String> comparedValues) {
        comparedValues.addAll(values.getValues());
    }

    private static void addRelatedUrisToComparedValues(AccessObject ao, Set<String> comparedValues) {
        comparedValues.addAll(Arrays.asList(ao.getResourceUris()));
    }

    private static boolean isQueryNotProvidedInConfiguration(Check check) {
        return StringUtils.isBlank((CharSequence)check.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSparqlSelectResults(Model model, String profileUri, String queryTemplate, AuthorizationRequest ar) {
        HashMap<String, Set<String>> queryMap = QueryResultsMapCache.get();
        String queryMapKey = SparqlSelectQueryResultsChecker.createQueryMapKey(profileUri, queryTemplate, ar);
        HashSet<String> results = new HashSet<String>();
        if (queryMap.containsKey(queryMapKey)) {
            results.addAll((Collection)queryMap.get(queryMapKey));
            return results;
        }
        ParameterizedSparqlString pss = new ParameterizedSparqlString();
        pss.setCommandText(queryTemplate);
        SparqlSelectQueryResultsChecker.setVariables(profileUri, ar, pss);
        String queryText = pss.toString();
        SparqlSelectQueryResultsChecker.debug("queryText: " + queryText);
        Query query = QueryFactory.create((String)queryText);
        try (QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet resultSet = queryExecution.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution qs = resultSet.nextSolution();
                SparqlSelectQueryResultsChecker.addSolutionValues(results, qs);
            }
        }
        SparqlSelectQueryResultsChecker.debug("query results: " + results);
        HashSet<String> queryMapValue = new HashSet<String>();
        queryMapValue.addAll(results);
        queryMap.put(queryMapKey, queryMapValue);
        QueryResultsMapCache.update(queryMap);
        return results;
    }

    private static void setVariables(String profileUri, AuthorizationRequest ar, ParameterizedSparqlString pss) {
        String matchingPropertyUri;
        String externalAuthId;
        pss.setIri(PROFILE_URI, profileUri);
        AccessObject object = ar.getAccessObject();
        Optional<String> uri = object.getUri();
        if (uri.isPresent()) {
            pss.setIri(OBJECT_URI, uri.get());
        }
        if (!StringUtils.isBlank((CharSequence)(externalAuthId = ar.getExternalAuthId()))) {
            pss.setLiteral(EXTERNAL_AUTH_ID, externalAuthId);
        }
        if (!StringUtils.isBlank((CharSequence)(matchingPropertyUri = SelfEditingConfiguration.getInstance().getMatchingPropertyUri()))) {
            pss.setIri(MATCHING_PROPERTY_URI, matchingPropertyUri);
        }
    }

    private static void addSolutionValues(Set<String> results, QuerySolution qs) {
        Iterator names = qs.varNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            RDFNode node = qs.get(name);
            if (node.isURIResource()) {
                results.add(node.asResource().getURI());
                continue;
            }
            if (!node.isLiteral()) continue;
            results.add(node.asLiteral().toString());
        }
    }

    private static void debug(String queryText) {
        if (log.isDebugEnabled()) {
            log.debug((Object)queryText);
        }
    }

    private static String createQueryMapKey(String profileUri, String queryTemplate, AuthorizationRequest ar) {
        AccessObject object;
        Optional<String> uri;
        String mapKey = queryTemplate + "." + profileUri;
        if (queryTemplate.contains("?objectUri") && (uri = (object = ar.getAccessObject()).getUri()).isPresent()) {
            mapKey = mapKey + "." + uri.get();
        }
        return mapKey;
    }

    private static void logVariableNotAvailable(String variable) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Query contains ?%s, but authorization request doesn't provide it.", variable));
        }
    }

    private static boolean externalAuthIdIsNotAvailable(AuthorizationRequest ar) {
        return StringUtils.isBlank((CharSequence)ar.getExternalAuthId());
    }

    private static boolean matchingPropertyUriIsNotAvailable() {
        return StringUtils.isBlank((CharSequence)SelfEditingConfiguration.getInstance().getMatchingPropertyUri());
    }

    private static boolean isProfileUriRelatedQuery(String queryTemplate) {
        return queryTemplate.contains("?profileUri");
    }
}

