/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.checks;

import edu.cornell.mannlib.vitro.webapp.auth.attributes.Attribute;
import edu.cornell.mannlib.vitro.webapp.auth.attributes.AttributeValueSet;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AbstractCheck;
import edu.cornell.mannlib.vitro.webapp.auth.checks.AttributeValueChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubjectRoleCheck
extends AbstractCheck {
    private static final Log log = LogFactory.getLog(SubjectRoleCheck.class);

    public SubjectRoleCheck(String uri, AttributeValueSet values) {
        super(uri, values);
    }

    @Override
    public boolean check(AuthorizationRequest ar) {
        ArrayList<String> inputValues = new ArrayList<String>(ar.getRoleUris());
        if (inputValues.isEmpty()) {
            inputValues.add("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#PUBLIC");
        }
        if (AttributeValueChecker.test(this, ar, inputValues.toArray(new String[0]))) {
            log.debug((Object)("Attribute match requested '" + inputValues + "'"));
            return true;
        }
        log.debug((Object)("Attribute don't match requested '" + inputValues + "'"));
        return false;
    }

    @Override
    public Attribute getAttributeType() {
        return Attribute.SUBJECT_ROLE_URI;
    }
}

