/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.ArrayIdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.UserBasedIdentifierBundleFactory;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ActiveIdentifierBundleFactories {
    private static ActiveIdentifierBundleFactories INSTANCE = new ActiveIdentifierBundleFactories();
    private final List<IdentifierBundleFactory> factories = new ArrayList<IdentifierBundleFactory>();

    private ActiveIdentifierBundleFactories() {
        INSTANCE = this;
    }

    public static ActiveIdentifierBundleFactories getInstance() {
        return INSTANCE;
    }

    public static void addFactory(IdentifierBundleFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory may not be null.");
        }
        ActiveIdentifierBundleFactories.INSTANCE.factories.add(factory);
    }

    public static List<String> getFactoryNames() {
        ArrayList<String> names = new ArrayList<String>();
        ActiveIdentifierBundleFactories actFact = ActiveIdentifierBundleFactories.getInstance();
        for (IdentifierBundleFactory factory : actFact.factories) {
            names.add(factory.toString());
        }
        return names;
    }

    static IdentifierBundle getIdentifierBundle(HttpServletRequest request) {
        return ActiveIdentifierBundleFactories.getInstance().getBundleForRequest(request);
    }

    public static IdentifierBundle getUserIdentifierBundle(UserAccount userAccount) {
        return ActiveIdentifierBundleFactories.getInstance().getBundleForUser(userAccount);
    }

    private IdentifierBundle getBundleForRequest(HttpServletRequest request) {
        ArrayIdentifierBundle ib = new ArrayIdentifierBundle(new Identifier[0]);
        for (IdentifierBundleFactory ibf : this.factories) {
            ib.addAll(ibf.getIdentifierBundle(request));
        }
        return ib;
    }

    private IdentifierBundle getBundleForUser(UserAccount userAccount) {
        ArrayIdentifierBundle ib = new ArrayIdentifierBundle(new Identifier[0]);
        for (IdentifierBundleFactory ibf : this.factories) {
            if (!(ibf instanceof UserBasedIdentifierBundleFactory)) continue;
            UserBasedIdentifierBundleFactory ubibf = (UserBasedIdentifierBundleFactory)ibf;
            ib.addAll(ubibf.getIdentifierBundleForUser(userAccount));
        }
        return ib;
    }
}

